/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.kind;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.kind.DiagramKindLabelProvider;
import org.eclipse.papyrus.uml.diagram.wizards.kind.RepresentationKindContentProvider;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RepresentationKindComposite
extends Composite {
    private static final Image CHECKED = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.uml.diagram.wizards", "icons/checked.gif");
    private static final Image UNCHECKED = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.uml.diagram.wizards", "icons/unchecked.gif");
    private Map<RepresentationKind, String> representationNames = new HashMap<RepresentationKind, String>();
    List<String> listNames = new ArrayList<String>();
    private Map<RepresentationKind, Integer> selectedRepresentations = new HashMap<RepresentationKind, Integer>();
    public TableViewer viewer;
    private GridData gridData;
    private ImageRegistry imageRegistry;

    public RepresentationKindComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTableViewer(this);
        this.imageRegistry = new ImageRegistry();
    }

    public void createTableViewer(final Composite container) {
        this.viewer = new TableViewer(container, 68354);
        this.gridData = new GridData(4, 4, true, true);
        this.viewer.getTable().setLayoutData((Object)this.gridData);
        Table table = this.viewer.getTable();
        this.viewer.setContentProvider((IContentProvider)new RepresentationKindContentProvider());
        table.setHeaderVisible(true);
        TableViewerColumn colCheckbox = this.createTableViewerColumn("", 20, this.viewer);
        colCheckbox.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                if (RepresentationKindComposite.this.selectedRepresentations.containsKey(element)) {
                    return CHECKED;
                }
                return UNCHECKED;
            }
        });
        colCheckbox.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){
            private CheckboxCellEditor checkboxCellEditor;

            protected void setValue(Object element, Object value) {
                if (this.checkboxCellEditor.getValue() == Boolean.TRUE) {
                    RepresentationKindComposite.this.selectedRepresentations.put((RepresentationKind)element, 1);
                } else {
                    RepresentationKindComposite.this.selectedRepresentations.remove(element);
                }
                RepresentationKindComposite.this.viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                return RepresentationKindComposite.this.selectedRepresentations.containsKey(element);
            }

            protected CellEditor getCellEditor(Object element) {
                this.checkboxCellEditor = new CheckboxCellEditor(container, 40);
                return this.checkboxCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        colCheckbox.getColumn().setResizable(false);
        TableViewerColumn colDiagramKind = this.createTableViewerColumn(Messages.RepresentationKindComposite_0, 200, this.viewer);
        colDiagramKind.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RepresentationKind) {
                    return ((RepresentationKind)element).getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof RepresentationKind) {
                    return RepresentationKindComposite.this.getIcon((RepresentationKind)element);
                }
                return null;
            }
        });
        TableViewerColumn colDiagramName = this.createTableViewerColumn(Messages.RepresentationKindComposite_2, 300, this.viewer);
        colDiagramName.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected void setValue(Object element, Object value) {
                RepresentationKindComposite.this.representationNames.put((RepresentationKind)element, (String)value);
                RepresentationKindComposite.this.viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                if (RepresentationKindComposite.this.representationNames.containsKey(element)) {
                    return RepresentationKindComposite.this.representationNames.get(element);
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)RepresentationKindComposite.this.viewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        colDiagramName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return RepresentationKindComposite.this.representationNames.get(element);
            }
        });
        TableViewerColumn colDiagramQuantity = this.createTableViewerColumn(Messages.RepresentationKindComposite_3, 70, this.viewer);
        colDiagramQuantity.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected void setValue(Object element, Object value) {
                RepresentationKindComposite.this.selectedRepresentations.put((RepresentationKind)element, Integer.parseInt((String)value));
                RepresentationKindComposite.this.viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                if (RepresentationKindComposite.this.selectedRepresentations.containsKey(element)) {
                    return RepresentationKindComposite.this.selectedRepresentations.get(element).toString();
                }
                return "0";
            }

            protected CellEditor getCellEditor(Object element) {
                TextCellEditor textCellEditor = new TextCellEditor((Composite)RepresentationKindComposite.this.viewer.getTable());
                textCellEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        if (!(value instanceof Integer)) {
                            return null;
                        }
                        return value.toString();
                    }
                });
                return textCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        colDiagramQuantity.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (RepresentationKindComposite.this.selectedRepresentations.containsKey(element)) {
                    return RepresentationKindComposite.this.selectedRepresentations.get(element).toString();
                }
                return "";
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    protected IBaseLabelProvider createDiagramKindLabelProvider() {
        return new DiagramKindLabelProvider();
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
        int tableItemHeight = this.viewer.getTable().getItemHeight();
        int tableItemCount = ((RepresentationKindContentProvider)this.viewer.getContentProvider()).getElements(input).length;
        this.gridData.minimumHeight = tableItemHeight * Math.max(3, Math.round(tableItemCount / 2));
        this.gridData.heightHint = tableItemHeight * Math.max(3, Math.round(tableItemCount / 2));
        ((Composite)this.viewer.getControl()).layout(true, true);
    }

    public ArrayList<RepresentationKind> getCheckElement() {
        ArrayList<RepresentationKind> list = new ArrayList<RepresentationKind>();
        Set<Map.Entry<RepresentationKind, Integer>> set = this.selectedRepresentations.entrySet();
        for (Map.Entry<RepresentationKind, Integer> me : set) {
            int nb = me.getValue();
            String tempname = this.representationNames.get(me.getKey());
            if (tempname == null || tempname.equalsIgnoreCase("")) {
                tempname = me.getKey().getName();
            }
            int i = 0;
            while (i < nb) {
                list.add(me.getKey());
                if (nb > 1) {
                    this.listNames.add(String.valueOf(tempname) + "_" + i);
                } else {
                    this.listNames.add(tempname);
                }
                ++i;
            }
        }
        return list;
    }

    public List<String> getDiagramName() {
        return this.listNames;
    }

    private Image getIcon(RepresentationKind kind) {
        String uri;
        Image image = this.imageRegistry.get(kind.getIcon());
        if (image == null && (uri = kind.getIcon()) != null) {
            try {
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)new URL(uri));
                this.imageRegistry.put(kind.getIcon(), descriptor);
                image = this.imageRegistry.get(kind.getIcon());
            }
            catch (MalformedURLException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return image;
    }

    public void dispose() {
        super.dispose();
        this.imageRegistry.dispose();
    }
}

