/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionFragmentEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public class DestructionOccurrenceSpecificationEditHelperAdvice
extends InteractionFragmentEditHelperAdvice {
    public void configureRequest(IEditCommandRequest request) {
        super.configureRequest(request);
        if (request instanceof CreateElementRequest) {
            this.configureCreateRequest((CreateElementRequest)request);
        }
    }

    protected void configureCreateRequest(CreateElementRequest request) {
        if (ElementUtil.isTypeOf(request.getElementType(), (IElementType)UMLElementTypes.TIME_CONSTRAINT) && request.getContainer() instanceof DestructionOccurrenceSpecification) {
            DestructionOccurrenceSpecification destruction = (DestructionOccurrenceSpecification)request.getContainer();
            Interaction owner = destruction.getEnclosingInteraction();
            if (owner == null) {
                owner = destruction.getEnclosingOperand();
            }
            if (owner != null) {
                request.setContainer((EObject)owner);
            }
        } else if (ElementUtil.isTypeOf(request.getElementType(), (IElementType)UMLElementTypes.TIME_OBSERVATION) && request.getContainer() instanceof DestructionOccurrenceSpecification) {
            DestructionOccurrenceSpecification destruction = (DestructionOccurrenceSpecification)request.getContainer();
            Package owner = destruction.getNearestPackage();
            Component component = this.getNearestComponent((Element)destruction);
            if (component != null && EcoreUtil.isAncestor((EObject)owner, (EObject)component)) {
                owner = component;
            }
            if (owner != null) {
                request.setContainer((EObject)owner);
            }
        }
    }

    protected Component getNearestComponent(Element element) {
        Component result = null;
        Element next = element;
        while (element != null && result == null) {
            if (next instanceof Component) {
                result = (Component)next;
            }
            next = next.getOwner();
        }
        return result;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        Stream<TimeObservation> timeObservations;
        DestructionOccurrenceSpecification destruction = (DestructionOccurrenceSpecification)request.getElementToDestroy();
        Interaction interaction = this.getInteraction((Element)destruction);
        Stream<TimeConstraint> timeConstraints = this.getTimeConstraints(interaction, (Element)destruction);
        Collection dependentsToDestroy = Stream.concat(timeConstraints, timeObservations = this.getTimeObservations(interaction, (Element)destruction)).collect(Collectors.toList());
        return dependentsToDestroy.isEmpty() ? null : request.getDestroyDependentsCommand(dependentsToDestroy);
    }

    protected Interaction getInteraction(Element element) {
        Interaction result = null;
        Element next = element;
        while (next != null && result == null) {
            if (next instanceof Interaction) {
                result = (Interaction)next;
            }
            next = next.getOwner();
        }
        return result;
    }

    protected Stream<TimeConstraint> getTimeConstraints(Interaction interaction, Element constrained) {
        if (interaction == null) {
            return Stream.empty();
        }
        return CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)constrained).stream().filter(setting -> setting.getEStructuralFeature() == UMLPackage.Literals.CONSTRAINT__CONSTRAINED_ELEMENT).map(setting -> (Constraint)setting.getEObject()).filter(TimeConstraint.class::isInstance).filter(c -> c.getConstrainedElements().size() == 1).filter(c -> this.getInteraction((Element)c) == interaction).map(TimeConstraint.class::cast);
    }

    protected Stream<TimeObservation> getTimeObservations(Interaction interaction, Element observed) {
        if (interaction == null) {
            return Stream.empty();
        }
        return CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)observed).stream().filter(setting -> setting.getEStructuralFeature() == UMLPackage.Literals.TIME_OBSERVATION__EVENT).map(setting -> (TimeObservation)setting.getEObject());
    }
}

