/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.contexts.util;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.properties.contexts.Annotatable;
import org.eclipse.papyrus.infra.properties.contexts.Annotation;
import org.eclipse.papyrus.infra.properties.contexts.ContextsFactory;
import org.eclipse.papyrus.infra.properties.contexts.DataContextRoot;

public class ContextAnnotations {
    public static final String ANNOTATION_SOURCE = "http://www.eclipse.org/papyrus/properties/contexts";
    public static final String DETAIL_MODEL = "model";
    public static final String DETAIL_LAYOUT_GENERATOR_CLASS = "layoutGenerator";

    private ContextAnnotations() {
    }

    public static EObject getSourceModel(Annotatable contextElement) {
        return ContextAnnotations.getSourceModel(contextElement, contextElement);
    }

    public static EObject getSourceModel(Annotatable contextElement, EObject context) {
        URI modelURI;
        Resource contextResource = context.eResource();
        if (contextResource == null) {
            return null;
        }
        EObject result = null;
        String modelURIDetail = ContextAnnotations.getAnnotation(contextElement, ANNOTATION_SOURCE, DETAIL_MODEL);
        URI uRI = modelURI = modelURIDetail == null ? null : URI.createURI((String)modelURIDetail, (boolean)true);
        if (modelURI != null && modelURI.isRelative()) {
            modelURI = modelURI.resolve(contextResource.getURI());
        }
        if (modelURI != null) {
            URI resolved = modelURI;
            result = Optional.ofNullable(contextResource.getResourceSet()).map(rset -> ContextAnnotations.safeGetEObject(rset, resolved)).orElseGet(() -> ContextAnnotations.createProxy(resolved));
        } else {
            Annotation annotation = contextElement.getAnnotation(ANNOTATION_SOURCE);
            if (annotation != null && !annotation.getReferences().isEmpty()) {
                result = (EObject)annotation.getReferences().get(0);
            }
        }
        return result;
    }

    private static EObject safeGetEObject(ResourceSet resourceSet, URI uri) {
        EObject result;
        try {
            result = resourceSet.getEObject(uri, true);
        }
        catch (Exception e) {
            result = ContextAnnotations.createProxy(uri);
        }
        return result;
    }

    private static EObject createProxy(URI proxyURI) {
        EObject result = EcoreFactory.eINSTANCE.createEObject();
        ((InternalEObject)result).eSetProxyURI(proxyURI);
        return result;
    }

    public static URI getSourceModelURI(Annotatable contextElement) {
        return ContextAnnotations.getSourceModelURI(contextElement, contextElement);
    }

    public static URI getSourceModelURI(Annotatable contextElement, EObject context) {
        Resource contextResource;
        URI result;
        String modelURIDetail = ContextAnnotations.getAnnotation(contextElement, ANNOTATION_SOURCE, DETAIL_MODEL);
        URI uRI = result = modelURIDetail == null ? null : URI.createURI((String)modelURIDetail, (boolean)true);
        if (result != null && result.isRelative() && (contextResource = context.eResource()) != null) {
            result = result.resolve(contextResource.getURI());
        }
        return result;
    }

    public static void setSourceModel(Annotatable contextElement, EObject sourceElement) {
        URI modelURI;
        URI uRI = modelURI = sourceElement == null ? null : EcoreUtil.getURI((EObject)sourceElement);
        if (modelURI != null) {
            ContextAnnotations.setAnnotation(contextElement, ANNOTATION_SOURCE, DETAIL_MODEL, modelURI.toString());
        } else {
            Annotation annotation = contextElement.getAnnotation(ANNOTATION_SOURCE);
            if (annotation != null) {
                annotation.getDetails().removeKey((Object)DETAIL_MODEL);
                annotation.getReferences().remove((Object)sourceElement);
            }
        }
    }

    public static Annotation getAnnotation(Annotatable contextElement, String source) {
        return ContextAnnotations.getAnnotation(contextElement, source, false);
    }

    public static Annotation getAnnotation(Annotatable contextElement, String source, boolean create) {
        Annotation result = contextElement.getAnnotation(source);
        if (result == null && create) {
            result = ContextsFactory.eINSTANCE.createAnnotation();
            result.setSource(source);
            contextElement.getAnnotations().add((Object)result);
        }
        return result;
    }

    public static String getAnnotation(Annotatable contextElement, String source, String detail) {
        Annotation annotation = ContextAnnotations.getAnnotation(contextElement, source);
        return annotation != null ? (String)annotation.getDetails().get((Object)detail) : null;
    }

    public static void setAnnotation(Annotatable contextElement, String source, String detail, String value) {
        ContextAnnotations.getAnnotation(contextElement, source, true).getDetails().put((Object)detail, (Object)value);
    }

    public static String getLayoutGeneratorClassName(DataContextRoot dataContext) {
        return ContextAnnotations.getAnnotation((Annotatable)dataContext, ANNOTATION_SOURCE, DETAIL_LAYOUT_GENERATOR_CLASS);
    }

    public static void setLayoutGeneratorClassName(DataContextRoot dataContext, String className) {
        ContextAnnotations.setAnnotation(dataContext, ANNOTATION_SOURCE, DETAIL_LAYOUT_GENERATOR_CLASS, className);
    }
}

