/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.TreeIterator;

public class Iterators2 {
    private Iterators2() {
    }

    public static <T> TreeIterator<T> filter(TreeIterator<?> treeIterator, Class<? extends T> type) {
        class FilteredTreeIterator
        extends AbstractIterator<T>
        implements TreeIterator<T> {
            final Iterator<? extends T> delegate;
            private final /* synthetic */ TreeIterator val$treeIterator;

            FilteredTreeIterator(TreeIterator treeIterator, Class clazz) {
                this.val$treeIterator = treeIterator;
                this.delegate = Iterators.filter((Iterator)treeIterator, (Class)clazz);
            }

            protected T computeNext() {
                return this.delegate.hasNext() ? this.delegate.next() : this.endOfData();
            }

            public void prune() {
                this.val$treeIterator.prune();
            }
        }
        return new FilteredTreeIterator(treeIterator, type);
    }

    public static <T> Iterator<T> autoPrune(TreeIterator<T> treeIterator, Predicate<? super T> shouldPrune) {
        Object result = treeIterator;
        if (shouldPrune != null) {
            class SelfPruningIterator
            extends AbstractIterator<T> {
                private final /* synthetic */ TreeIterator val$treeIterator;
                private final /* synthetic */ Predicate val$shouldPrune;

                SelfPruningIterator(TreeIterator treeIterator, Predicate predicate) {
                    this.val$treeIterator = treeIterator;
                    this.val$shouldPrune = predicate;
                }

                protected T computeNext() {
                    Object result;
                    if (!this.val$treeIterator.hasNext()) {
                        result = this.endOfData();
                    } else {
                        result = this.val$treeIterator.next();
                        if (this.val$shouldPrune.test(result)) {
                            this.val$treeIterator.prune();
                        }
                    }
                    return result;
                }
            }
            result = new SelfPruningIterator(treeIterator, shouldPrune);
        }
        return result;
    }

    public static <T> Spliterator<T> spliterator(TreeIterator<T> treeIterator) {
        return Iterators2.spliterator(treeIterator, null);
    }

    public static <T> Spliterator<T> spliterator(TreeIterator<T> treeIterator, Predicate<? super T> shouldPrune) {
        Iterator<? super T> delegate = Iterators2.autoPrune(treeIterator, shouldPrune);
        return Spliterators.spliteratorUnknownSize(delegate, 273);
    }

    public static <T> Stream<T> stream(TreeIterator<T> treeIterator) {
        return Iterators2.stream(treeIterator, null);
    }

    public static <T> Stream<T> stream(TreeIterator<T> treeIterator, Predicate<? super T> shouldPrune) {
        return StreamSupport.stream(Iterators2.spliterator(treeIterator, shouldPrune), false);
    }
}

