/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractColumnCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

public class SortColumnCommand
extends AbstractColumnCommand {
    private boolean accumulate;
    private SortDirectionEnum sortDirection;

    public SortColumnCommand(ILayer layer, int columnPosition) {
        this(layer, columnPosition, false, null);
    }

    public SortColumnCommand(ILayer layer, int columnPosition, boolean accumulate) {
        this(layer, columnPosition, accumulate, null);
    }

    public SortColumnCommand(ILayer layer, int columnPosition, SortDirectionEnum sortDirection) {
        this(layer, columnPosition, false, sortDirection);
    }

    public SortColumnCommand(ILayer layer, int columnPosition, boolean accumulate, SortDirectionEnum sortDirection) {
        super(layer, columnPosition);
        this.accumulate = accumulate;
        this.sortDirection = sortDirection;
    }

    protected SortColumnCommand(SortColumnCommand command) {
        super(command);
        this.accumulate = command.accumulate;
        this.sortDirection = command.sortDirection;
    }

    public boolean isAccumulate() {
        return this.accumulate;
    }

    public SortDirectionEnum getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public SortColumnCommand cloneCommand() {
        return new SortColumnCommand(this);
    }
}

