/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter;

import com.google.common.base.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.uml2.uml.Profile;

public class AppliedProfileReadOptionalyWriteHandler
extends AbstractReadOnlyHandler {
    public AppliedProfileReadOptionalyWriteHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
        if (this.getEditingDomain() != null && axes.contains(ReadOnlyAxis.DISCRETION)) {
            Resource mainUmlResource = null;
            if (this.getEditingDomain().getResourceSet() instanceof ModelSet) {
                UmlModel umlModel = (UmlModel)((ModelSet)this.getEditingDomain().getResourceSet()).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                if (umlModel == null) {
                    return Optional.absent();
                }
                mainUmlResource = umlModel.getResource();
            }
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                Resource resource = this.getEditingDomain().getResourceSet().getResource(uri.trimFragment(), false);
                if (this.isProfileResource(resource) && mainUmlResource != resource) {
                    return Optional.absent();
                }
                ++n2;
            }
        }
        return Optional.absent();
    }

    private boolean isProfileResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        return !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Profile;
    }

    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        return Optional.of((Object)Boolean.TRUE);
    }
}

