/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class FigureHitTestUtil {
    public static final FigureHitTestUtil INSTANCE = new FigureHitTestUtil();
    private static final int FUZZ_FACTOR = 2;
    private final Rectangle fuzzyPoint = new Rectangle(0, 0, 5, 5);

    private FigureHitTestUtil() {
    }

    public final List<? extends IFigure> getChildren(IFigure figure) {
        return figure.getChildren();
    }

    public boolean fuzzyHitTest(PointList polygon, int x, int y) {
        boolean result = polygon.polygonContainsPoint(x, y);
        if (!result) {
            this.fuzzyPoint.setLocation(x - 2, y - 2);
            result = polygon.intersects(this.fuzzyPoint);
        }
        return result;
    }

    public boolean anyChildContainsPoint(IFigure figure, int x, int y) {
        boolean result = false;
        List<? extends IFigure> children = this.getChildren(figure);
        int i = children.size() - 1;
        while (i >= 0) {
            IFigure next = children.get(i);
            if (next.isVisible() && next.containsPoint(x, y)) {
                result = true;
                break;
            }
            --i;
        }
        return result;
    }

    public IFigure findChildAt(IFigure figure, int x, int y, TreeSearch search) {
        IFigure result = null;
        List<? extends IFigure> children = this.getChildren(figure);
        int i = children.size() - 1;
        while (i >= 0) {
            IFigure next = children.get(i);
            if (next.isVisible() && (next = next.findFigureAt(x, y, search)) != null) {
                result = next;
                break;
            }
            --i;
        }
        return result;
    }
}

