/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.uml2.uml.Profile;

public class TreeNodeUtils {
    public static boolean isAddType(TreeNode treeNode, Profile profile) {
        Match match;
        return TreeNodeUtils.getNearestProfile(treeNode) == profile && treeNode.getData() instanceof Match && TreeNodeUtils.getNewElement(match = (Match)treeNode.getData()) != null && TreeNodeUtils.getOldElement(match) == null;
    }

    public static EObject getAddedElement(TreeNode treeNode) {
        Match match;
        if (treeNode.getData() instanceof Match && TreeNodeUtils.getNewElement(match = (Match)treeNode.getData()) != null && TreeNodeUtils.getOldElement(match) == null) {
            return TreeNodeUtils.getNewElement(match);
        }
        return null;
    }

    public static EStructuralFeature getAddedStructuralFeature(TreeNode treeNode) {
        Match match;
        if (treeNode.getData() instanceof Match && TreeNodeUtils.getNewElement(match = (Match)treeNode.getData()) != null && TreeNodeUtils.getOldElement(match) == null) {
            for (TreeNode child : treeNode.getChildren()) {
                if (child.getData() instanceof AttributeChange) {
                    AttributeChange attributeChange = (AttributeChange)child.getData();
                    return attributeChange.getAttribute();
                }
                if (!(child.getData() instanceof ReferenceChange)) continue;
                ReferenceChange referenceChange = (ReferenceChange)child.getData();
                return referenceChange.getReference();
            }
        }
        return null;
    }

    public static boolean isDeleteType(TreeNode treeNode, Profile profile) {
        Match match;
        return TreeNodeUtils.getNearestProfile(treeNode) == profile && treeNode.getData() instanceof Match && TreeNodeUtils.getNewElement(match = (Match)treeNode.getData()) == null && TreeNodeUtils.getOldElement(match) != null;
    }

    public static EObject getDeletedElement(TreeNode treeNode) {
        Match match;
        if (treeNode.getData() instanceof Match && TreeNodeUtils.getNewElement(match = (Match)treeNode.getData()) == null && TreeNodeUtils.getOldElement(match) != null) {
            return TreeNodeUtils.getOldElement(match);
        }
        return null;
    }

    public static EObject getDeletedElementOwner(TreeNode treeNode) {
        Match match;
        if (treeNode.getData() instanceof Match && TreeNodeUtils.getNewElement(match = (Match)treeNode.getData()) == null && TreeNodeUtils.getOldElement(match) != null && match.eContainer() instanceof Match) {
            if (TreeNodeUtils.getNewElement((Match)match.eContainer()) != null) {
                return TreeNodeUtils.getNewElement((Match)match.eContainer());
            }
            return TreeNodeUtils.getOldElement((Match)match.eContainer());
        }
        return null;
    }

    public static EStructuralFeature getDeletedStructuralFeature(TreeNode treeNode) {
        Match match;
        if (treeNode.getData() instanceof Match && TreeNodeUtils.getNewElement(match = (Match)treeNode.getData()) == null && TreeNodeUtils.getOldElement(match) != null) {
            for (TreeNode child : treeNode.getChildren()) {
                if (child.getData() instanceof AttributeChange) {
                    AttributeChange attributeChange = (AttributeChange)child.getData();
                    return attributeChange.getAttribute();
                }
                if (!(child.getData() instanceof ReferenceChange)) continue;
                ReferenceChange referenceChange = (ReferenceChange)child.getData();
                return referenceChange.getReference();
            }
        }
        return null;
    }

    public static boolean isChangeType(TreeNode treeNode, Profile profile) {
        Diff diff;
        return TreeNodeUtils.getNearestProfile(treeNode) == profile && treeNode.getData() instanceof Diff && (diff = (Diff)treeNode.getData()).getKind() == DifferenceKind.CHANGE;
    }

    public static EObject getChangedElement(TreeNode treeNode) {
        Diff diff;
        if (treeNode.getData() instanceof Diff && (diff = (Diff)treeNode.getData()).getKind() == DifferenceKind.CHANGE) {
            return TreeNodeUtils.getNewElement(diff.getMatch());
        }
        return null;
    }

    public static EObject getChangedOldElement(TreeNode treeNode) {
        Diff diff;
        if (treeNode.getData() instanceof Diff && (diff = (Diff)treeNode.getData()).getKind() == DifferenceKind.CHANGE) {
            return TreeNodeUtils.getOldElement(diff.getMatch());
        }
        return null;
    }

    public static EStructuralFeature getChangedAttribute(TreeNode treeNode) {
        Diff diff;
        if (treeNode.getData() instanceof Diff && (diff = (Diff)treeNode.getData()).getKind() == DifferenceKind.CHANGE) {
            if (diff instanceof AttributeChange) {
                AttributeChange attributeChange = (AttributeChange)diff;
                return attributeChange.getAttribute();
            }
            if (diff instanceof ReferenceChange) {
                ReferenceChange referenceChange = (ReferenceChange)diff;
                return referenceChange.getReference();
            }
        }
        return null;
    }

    public static boolean isMoveChange(TreeNode treeNode) {
        Diff diff;
        return treeNode.getData() instanceof Diff && (diff = (Diff)treeNode.getData()).getKind() == DifferenceKind.MOVE;
    }

    public static Object getMovedElement(TreeNode treeNode) {
        Diff diff;
        if (treeNode.getData() instanceof Diff && (diff = (Diff)treeNode.getData()).getKind() == DifferenceKind.MOVE && diff instanceof ReferenceChange) {
            ReferenceChange attributeChange = (ReferenceChange)diff;
            return attributeChange.getValue();
        }
        return null;
    }

    public static EObject getMovedTargetContainer(TreeNode treeNode) {
        Diff diff;
        if (treeNode.getData() instanceof Diff && (diff = (Diff)treeNode.getData()).getKind() == DifferenceKind.MOVE && diff instanceof ReferenceChange) {
            ReferenceChange attributeChange = (ReferenceChange)diff;
            return attributeChange.getValue().eContainer();
        }
        return null;
    }

    public static EObject getMovedSourceContainer(TreeNode treeNode, Comparison comparison) {
        ReferenceChange attributeChange;
        EObject newElement;
        EObject oldElement;
        Diff diff;
        if (treeNode.getData() instanceof Diff && (diff = (Diff)treeNode.getData()).getKind() == DifferenceKind.MOVE && diff instanceof ReferenceChange && (oldElement = TreeNodeUtils.getOldElementFromNewElement(newElement = (attributeChange = (ReferenceChange)diff).getValue(), (EList<Match>)comparison.getMatches())) != null) {
            EObject oldContainer = oldElement.eContainer();
            return TreeNodeUtils.getNewElementFromOldElement(oldContainer, (EList<Match>)comparison.getMatches());
        }
        return null;
    }

    public static EObject getOldElement(Match match) {
        return match.getRight();
    }

    public static EObject getNewElement(Match match) {
        return match.getLeft();
    }

    private static EObject getOldElementFromNewElement(EObject element, EList<Match> matches) {
        for (Match match : matches) {
            if (TreeNodeUtils.getNewElement(match) == element) {
                return TreeNodeUtils.getOldElement(match);
            }
            EObject result = TreeNodeUtils.getOldElementFromNewElement(element, (EList<Match>)match.getSubmatches());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static EObject getNewElementFromOldElement(EObject element, EList<Match> matches) {
        for (Match match : matches) {
            if (TreeNodeUtils.getOldElement(match) == element) {
                return TreeNodeUtils.getNewElement(match);
            }
            EObject result = TreeNodeUtils.getNewElementFromOldElement(element, (EList<Match>)match.getSubmatches());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Profile getNearestProfile(TreeNode treeNode) {
        Match match;
        if (treeNode.getData() instanceof Match && (match = (Match)treeNode.getData()).getLeft() instanceof Profile) {
            return (Profile)match.getLeft();
        }
        return TreeNodeUtils.getNearestProfile(treeNode.getParent());
    }
}

