/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.clipboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;

public class PapyrusClipboard<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -6902170636133989420L;
    public static PapyrusClipboard<Object> instance = null;
    private static String UNKNOW_TYPE = "unknown";
    protected String containerType;
    private Map<EObject, Object> sourceToInternalClipboard = new HashMap<EObject, Object>();
    private Map<Object, EObject> internalClipboardToTargetCopy = new HashMap<Object, EObject>();
    private Map<String, Map<E, IClipboardAdditionalData>> strategiesAdditionalData = new HashMap<String, Map<E, IClipboardAdditionalData>>();

    public static PapyrusClipboard<Object> getInstance() {
        if (instance == null) {
            instance = new PapyrusClipboard();
        }
        return instance;
    }

    public static void setInstance(PapyrusClipboard<Object> pInstance) {
        instance = pInstance;
    }

    public static PapyrusClipboard<Object> getNewInstance() {
        instance = new PapyrusClipboard();
        return instance;
    }

    public String getContainerType() {
        if (this.containerType != null) {
            return this.containerType;
        }
        return UNKNOW_TYPE;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public void resetTarget() {
        this.internalClipboardToTargetCopy = new HashMap<Object, EObject>();
    }

    public boolean isEmptyWithNoAdditionalData() {
        return this.isEmpty() && this.getStrategiesAdditionalData().isEmpty();
    }

    public Map<EObject, Object> getSourceToInternalClipboard() {
        return this.sourceToInternalClipboard;
    }

    public Map<Object, EObject> getInternalClipboardToTargetCopy() {
        return this.internalClipboardToTargetCopy;
    }

    public void addInternalCopyInClipboard(EObject source, Object copy) {
        PapyrusClipboard.getInstance().add(copy);
        this.sourceToInternalClipboard.put(source, copy);
    }

    public void addAllInternalCopyInClipboard(Map<EObject, Object> mapInternalCopyInClipboard) {
        PapyrusClipboard.getInstance().addAll(mapInternalCopyInClipboard.values());
        this.sourceToInternalClipboard.putAll(mapInternalCopyInClipboard);
    }

    public void addAllInternalToTargetCopy(Map<Object, EObject> mapInternalClipboardToTargetCopy) {
        this.internalClipboardToTargetCopy.putAll(mapInternalClipboardToTargetCopy);
    }

    public void addTargetForInternalCopy(Object copy, EObject target) {
        this.internalClipboardToTargetCopy.put(copy, target);
    }

    public Iterator<EObject> iterateOnSource() {
        return this.sourceToInternalClipboard.keySet().iterator();
    }

    public Object getCopyFromSource(EObject eObject) {
        return this.sourceToInternalClipboard.get(eObject);
    }

    public Map<String, Map<E, IClipboardAdditionalData>> getStrategiesAdditionalData() {
        return this.strategiesAdditionalData;
    }

    public void pushAdditionalData(String key, Map<E, IClipboardAdditionalData> strategyAdditionalData) {
        this.getStrategiesAdditionalData().put(key, strategyAdditionalData);
    }

    public Map<E, IClipboardAdditionalData> getAdditionalDataForStrategy(String key) {
        return this.getStrategiesAdditionalData().get(key);
    }

    public EObject getTragetCopyFromInternalClipboardCopy(Object object) {
        return this.internalClipboardToTargetCopy.get(object);
    }

    public Collection<EObject> getTarget() {
        return this.internalClipboardToTargetCopy.values();
    }
}

