/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.SignalUtil;
import org.eclipse.papyrus.uml.tools.utils.TypedElementUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.TypedElement;

public class FloatingLabelHelper
extends StereotypedElementLabelHelper {
    private static final String SLASH = "/";
    private static final String DOUBLE_DOT = ": ";
    private static final String ONE_SPACE = " ";
    private static final String EMPTY = "";
    private static final String STEREOTYPE = "stereotype";
    private static FloatingLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    public static FloatingLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new FloatingLabelHelper();
        }
        return labelHelper;
    }

    protected FloatingLabelHelper() {
        this.masks.put("visibility", "Visibility");
        this.masks.put("derived", "Derived");
        this.masks.put("name", "Name");
        this.masks.put("type", "Type");
        this.masks.put("multiplicity", "Multiplicity");
        this.masks.put("defaultValue", "Default Value");
        this.masks.put("direction", "Direction");
        this.masks.put("returnType", "returnType");
        this.masks.put("returnMultiplicity", "Return Multiplicity");
    }

    @Override
    protected String elementLabel(GraphicalEditPart editPart) {
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy == null) {
            policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"INDRIRECT_MASK_MANAGED_LABEL");
        }
        Set<String> displayValue = Collections.emptySet();
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return this.parseString(editPart, displayValue);
    }

    protected String parseString(GraphicalEditPart editPart, Collection<String> displayValue) {
        NamedElement namedElement = this.getUMLElement(editPart);
        StringBuilder buffer = new StringBuilder();
        if (displayValue.contains(STEREOTYPE)) {
            buffer.append(this.stereotypesToDisplay((GraphicalEditPart)editPart.getParent()));
        }
        if (namedElement != null) {
            buffer.append(this.getCustomLabel(namedElement, displayValue));
        }
        return buffer.toString();
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public NamedElement getUMLElement(GraphicalEditPart editPart) {
        View view;
        if (editPart.getModel() instanceof View && (view = (View)editPart.getModel()).getElement() instanceof NamedElement) {
            return (NamedElement)view.getElement();
        }
        return null;
    }

    @Override
    protected String labelToDisplay(GraphicalEditPart editPart) {
        return this.elementLabel(editPart);
    }

    public String getCustomLabel(NamedElement namedElement, Collection<String> maskValues) {
        if (namedElement instanceof Signal) {
            return SignalUtil.getCustomLabel((Signal)((Signal)namedElement), maskValues);
        }
        StringBuilder buffer = new StringBuilder();
        if (maskValues.contains("visibility")) {
            buffer.append(ONE_SPACE);
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)namedElement));
        }
        if (namedElement instanceof Association && maskValues.contains("derived") && ((Association)namedElement).isDerived()) {
            buffer.append(SLASH);
        }
        if (maskValues.contains("name")) {
            buffer.append(ONE_SPACE);
            String name = UMLLabelInternationalization.getInstance().getLabel(namedElement);
            buffer.append(name != null ? name : EMPTY);
        }
        if (namedElement instanceof TypedElement && (maskValues.contains("returnType") || maskValues.contains("type"))) {
            buffer.append(DOUBLE_DOT);
            buffer.append(TypedElementUtil.getTypeAsString((TypedElement)((TypedElement)namedElement)));
        }
        if (namedElement instanceof MultiplicityElement && maskValues.contains("multiplicity")) {
            String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)((MultiplicityElement)namedElement));
            buffer.append(multiplicity);
        }
        return buffer.toString();
    }
}

