/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.views.search.Activator;
import org.eclipse.papyrus.views.search.utils.IServiceRegistryTracker;

public class DefaultServiceRegistryTracker
implements IServiceRegistryTracker {
    private static final ExecutorService EXEC = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicInteger threadNum = new AtomicInteger();
        private final ThreadGroup group = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Service Registry Tracker Threads");

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(this.group, r, "SvcRegTracker-" + this.threadNum.incrementAndGet());
            result.setDaemon(true);
            return result;
        }
    });
    private Set<TrackerReference> references = new HashSet<TrackerReference>();
    private ReferenceQueue<Object> queue = new ReferenceQueue();
    private int count = 0;
    private boolean active = true;
    private Runnable reaper;

    @Override
    public synchronized boolean isActive() {
        return this.active;
    }

    private void checkActive() {
        if (!this.active) {
            throw new IllegalStateException("not active");
        }
    }

    @Override
    public synchronized void track(Object owner, ServicesRegistry serviceRegistry) {
        this.checkActive();
        TrackerReference existing = this.getReference(serviceRegistry);
        if (existing == null) {
            this.references.add(new TrackerReference(owner, serviceRegistry));
            ++this.count;
            this.reapLater();
        } else {
            Object actualOwner = existing.get();
            if (actualOwner != null && actualOwner != owner) {
                throw new IllegalArgumentException("registry already tracked against a different owner");
            }
        }
    }

    @Override
    public synchronized void untrack(Object owner, ServicesRegistry serviceRegistry) {
        this.checkActive();
        TrackerReference existing = this.getReference(serviceRegistry);
        if (existing != null && existing.get() == owner) {
            this.references.remove(existing);
        }
    }

    private TrackerReference getReference(ServicesRegistry serviceRegistry) {
        TrackerReference result = null;
        for (TrackerReference next : this.references) {
            if (!next.matches(serviceRegistry)) continue;
            result = next;
        }
        return result;
    }

    private void reapLater() {
        if (this.reaper == null) {
            this.reaper = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (DefaultServiceRegistryTracker.this.dequeue()) {
                            }
                        }
                        catch (InterruptedException e) {
                            Activator.log.error("Service registry reaper thread interrupted. How?", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            };
            EXEC.execute(this.reaper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dequeue() throws InterruptedException {
        boolean result = true;
        TrackerReference ref = (TrackerReference)this.queue.remove();
        DefaultServiceRegistryTracker defaultServiceRegistryTracker = this;
        synchronized (defaultServiceRegistryTracker) {
            if (this.references.remove(ref)) {
                ref.dispose();
            }
            if (--this.count <= 0) {
                this.reaper = null;
                this.active = false;
                result = false;
            }
        }
        return result;
    }

    private class TrackerReference
    extends WeakReference<Object> {
        private final ServicesRegistry serviceRegistry;

        TrackerReference(Object owner, ServicesRegistry serviceRegistry) {
            super(owner, DefaultServiceRegistryTracker.this.queue);
            this.serviceRegistry = serviceRegistry;
        }

        void dispose() {
            try {
                this.serviceRegistry.disposeRegistry();
            }
            catch (Exception e) {
                Activator.log.error("Exception in disposal of service registry that is no longer in use.", (Throwable)e);
            }
        }

        boolean matches(ServicesRegistry serviceRegistry) {
            return this.serviceRegistry == serviceRegistry;
        }
    }
}

