/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.reconciler;

import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;

public class DiagramVersioningUtils {
    public static final String COMPATIBILITY_VERSION = "diagram_compatibility_version";
    public static final String UNDEFINED_VERSION = "undefined";
    private static final String DELIM_VERSION = ".";

    private static String CURRENT_DIAGRAM_VERSION() {
        return "1.4.0";
    }

    public static void stampCurrentVersion(Diagram diagram) {
        DiagramVersioningUtils.setCompatibilityVersion((View)diagram, DiagramVersioningUtils.CURRENT_DIAGRAM_VERSION());
    }

    public static ICommand createStampCurrentVersionCommand(Diagram diagram) {
        StringValueStyle style = DiagramVersioningUtils.findOrCreateCompatibilityStyle((View)diagram);
        if (style.eContainer() == null) {
            style.setStringValue(DiagramVersioningUtils.CURRENT_DIAGRAM_VERSION());
            return new SetValueCommand(new SetRequest((EObject)diagram, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Styles(), (Object)style));
        }
        return new SetValueCommand(new SetRequest((EObject)style, (EStructuralFeature)NotationPackage.eINSTANCE.getStringValueStyle_StringValue(), (Object)DiagramVersioningUtils.CURRENT_DIAGRAM_VERSION()));
    }

    public static String getCompatibilityVersion(View view) {
        StringValueStyle semanticStyle = (StringValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), COMPATIBILITY_VERSION);
        return semanticStyle == null ? UNDEFINED_VERSION : semanticStyle.getStringValue();
    }

    public static void setCompatibilityVersion(View view, String version) {
        StringValueStyle style = DiagramVersioningUtils.findOrCreateCompatibilityStyle(view);
        style.setStringValue(version);
        if (style.eContainer() == null) {
            view.getStyles().add((Object)style);
        }
    }

    private static StringValueStyle findOrCreateCompatibilityStyle(View view) {
        StringValueStyle style = (StringValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), COMPATIBILITY_VERSION);
        if (style == null) {
            style = NotationFactory.eINSTANCE.createStringValueStyle();
            style.setName(COMPATIBILITY_VERSION);
        }
        return style;
    }

    public static boolean isOfCurrentPapyrusVersion(Diagram diagram) {
        return DiagramVersioningUtils.isCurrentPapyrusVersion(DiagramVersioningUtils.getCompatibilityVersion((View)diagram));
    }

    public static boolean isCurrentPapyrusVersion(String version) {
        return DiagramVersioningUtils.CURRENT_DIAGRAM_VERSION().equals(version);
    }

    public static boolean isBeforeVersion(String referenceVersion, String testedVersion) {
        boolean before = false;
        StringTokenizer targetVersionTokenizer = new StringTokenizer(referenceVersion, DELIM_VERSION);
        StringTokenizer sourceVersionTokenizer = new StringTokenizer(testedVersion, DELIM_VERSION);
        try {
            if (targetVersionTokenizer.countTokens() == sourceVersionTokenizer.countTokens()) {
                int sourceIntermediateVersion;
                int targetIntermediateVersion;
                int sourceMainVersion;
                int targetMainVersion = Integer.parseInt(targetVersionTokenizer.nextToken());
                before = targetMainVersion == (sourceMainVersion = Integer.parseInt(sourceVersionTokenizer.nextToken())) ? (targetIntermediateVersion = Integer.parseInt(targetVersionTokenizer.nextToken())) > (sourceIntermediateVersion = Integer.parseInt(sourceVersionTokenizer.nextToken())) : targetMainVersion > sourceMainVersion;
            }
        }
        catch (NumberFormatException e) {
            Activator.log.error((Throwable)e);
        }
        return before;
    }
}

