/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.ui.architecture.providers.MergedArchitectureItemProvider;

public class MergedArchitectureViewpointItemProvider
extends MergedArchitectureItemProvider {
    public MergedArchitectureViewpointItemProvider(AdapterFactory adapterFactory, MergedArchitectureViewpoint owner) {
        super(adapterFactory, (MergedADElement)owner);
    }

    protected ArchitectureViewpoint getADElement() {
        return (ArchitectureViewpoint)this.getValue();
    }

    protected MergedArchitectureViewpoint getMergedElement() {
        return (MergedArchitectureViewpoint)this.getOwner();
    }

    public Object getParent(Object object) {
        if (object instanceof MergedArchitectureViewpoint) {
            return ((MergedArchitectureViewpoint)object).getContext();
        }
        return super.getParent(object);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof MergedArchitectureViewpoint) {
            MergedArchitectureViewpoint viewpoint = (MergedArchitectureViewpoint)object;
            return !viewpoint.getConcerns().isEmpty() || !viewpoint.getRepresentationKinds().isEmpty();
        }
        return super.hasChildren(object);
    }

    public Collection<?> getChildren(Object object) {
        if (object instanceof MergedArchitectureViewpoint) {
            MergedArchitectureViewpoint viewpoint = (MergedArchitectureViewpoint)object;
            ArrayList<Object> result = new ArrayList<Object>();
            this.wrapInto(viewpoint, viewpoint.getConcerns(), result);
            this.wrapInto(viewpoint, viewpoint.getRepresentationKinds(), result);
            return result;
        }
        return super.getChildren(object);
    }

    protected Predicate<IItemPropertyDescriptor> propertyDescriptorFilter(Object object) {
        Set<EReference> unwanted = Set.of(ArchitecturePackage.Literals.ARCHITECTURE_VIEWPOINT__CONCERNS, ArchitecturePackage.Literals.ARCHITECTURE_VIEWPOINT__REPRESENTATION_KINDS);
        return pd -> unwanted.contains(pd.getFeature(object));
    }
}

