/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading.internal.ui.editor;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.services.resourceloading.internal.ui.UIPlugin;
import org.eclipse.papyrus.infra.services.resourceloading.internal.ui.editor.LoadDiagramCommand;

public class LoadResourceSnippet
implements IModelSetSnippet {
    private LoadResourceAdapter adapter;

    public void start(ModelSet startingModel) {
        this.adapter = new LoadResourceAdapter();
        startingModel.eAdapters().add((Object)this.adapter);
    }

    public void dispose(ModelSet stoppingModel) {
        stoppingModel.eAdapters().remove((Object)this.adapter);
        this.adapter = null;
    }

    private class LoadResourceAdapter
    extends ResourceAdapter {
        private LoadResourceAdapter() {
        }

        protected void handleResourceLoaded(Resource resource) {
            IPageManager pageManager = null;
            ISashWindowsContainer sashContainer = null;
            try {
                pageManager = ServiceUtilsForResource.getInstance().getIPageManager((Object)resource);
                sashContainer = (ISashWindowsContainer)ServiceUtilsForResource.getInstance().getService(ISashWindowsContainer.class, (Object)resource);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            if (pageManager != null) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)resource);
                LoadDiagramCommand loadCommand = new LoadDiagramCommand(resource, pageManager, sashContainer);
                if (loadCommand.canExecute()) {
                    try {
                        TransactionHelper.run((EditingDomain)editingDomain, (Runnable)loadCommand);
                    }
                    catch (InterruptedException e) {
                        UIPlugin.log.error((Throwable)e);
                    }
                    catch (RollbackException e) {
                        UIPlugin.log.error((Throwable)e);
                    }
                }
            }
        }
    }
}

