/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.papyrus.infra.widgets.databinding.StyledTextObservableValue;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.util.ISetPapyrusConverter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;

public class CompletionStyledTextObservableValue
extends StyledTextObservableValue
implements ISetPapyrusConverter {
    protected IPapyrusConverter parser;

    public CompletionStyledTextObservableValue(StyledText text, IObservableValue modelProperty, int eventType) {
        super(text, modelProperty, eventType);
    }

    @Override
    protected void doSetValue(Object value) {
        String editValue = this.parser.canonicalToEditValue(value, 0);
        if (editValue instanceof String) {
            super.doSetValue(editValue);
        } else {
            super.doSetValue(value);
        }
    }

    @Override
    protected Object doGetValue() {
        Object newValue = super.doGetValue();
        if (newValue instanceof String) {
            if ("<Undefined>".equals(newValue)) {
                return null;
            }
            Object result = this.parser.editToCanonicalValue((String)newValue, 0);
            return result;
        }
        return null;
    }

    @Override
    public void setPapyrusConverter(IPapyrusConverter parser) {
        this.parser = parser;
    }

    @Override
    public void handleEvent(Event event) {
        Object newValue;
        final Object oldValue = this.currentValue;
        this.currentValue = newValue = this.getValue();
        if ((this.eventType & event.type) != 0) {
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return newValue;
                }
            });
        }
    }
}

