/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.export.image;

public enum ImageFormat {
    BMP("bmp", "BMP files (*.bmp)", "*.bmp"),
    JPG("jpg", "JPG files (*.jpg)", "*.jpg"),
    JPEG("jpeg", "JPEG files (*.jpeg)", "*.jpeg"),
    PNG("png", "PNG files (*.png)", "*.png");

    public static final String[] IMAGE_EXTENSION_LIST;
    public static final String[] IMAGE_FILTER_NAME_LIST;
    public static final String[] IMAGE_FILTER_EXTENSION_LIST;
    private final String imageExtension;
    private final String imageExtensionFilterName;
    private final String imageFilterExtension;

    static {
        IMAGE_EXTENSION_LIST = new String[]{PNG.getImageExtension(), BMP.getImageExtension(), JPG.getImageExtension(), JPEG.getImageExtension()};
        IMAGE_FILTER_NAME_LIST = new String[]{PNG.getImageFilterName(), BMP.getImageFilterName(), JPG.getImageFilterName(), JPEG.getImageFilterName()};
        IMAGE_FILTER_EXTENSION_LIST = new String[]{PNG.getImageFilterExtension(), BMP.getImageFilterExtension(), JPG.getImageFilterExtension(), JPEG.getImageFilterExtension()};
    }

    private ImageFormat(String imageExtension, String imageExtensionFilterName, String imageFilterExtension) {
        this.imageExtension = imageExtension;
        this.imageExtensionFilterName = imageExtensionFilterName;
        this.imageFilterExtension = imageFilterExtension;
    }

    public final String getImageExtension() {
        return this.imageExtension;
    }

    public final String getImageFilterName() {
        return this.imageExtensionFilterName;
    }

    public final String getImageFilterExtension() {
        return this.imageFilterExtension;
    }

    public static final ImageFormat getDefaultImageFormat() {
        return PNG;
    }
}

