/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public class ResizeParentFigureCommand
extends AbstractTransactionalCommand {
    private DefaultSizeNodeFigure parent = null;
    private ChangeBoundsRequest request;
    private int oldWidth;
    private int oldHeight;
    private int newWidth = -1;
    private int newHeight = -1;

    public ResizeParentFigureCommand(TransactionalEditingDomain domain, DefaultSizeNodeFigure portFigure, ChangeBoundsRequest request) {
        super(domain, "Resize Full Port Figure", null);
        this.parent = portFigure;
        this.request = request;
        this.oldHeight = portFigure.getBounds().height;
        this.oldWidth = portFigure.getBounds().width;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.newWidth = this.oldWidth + this.request.getSizeDelta().width;
        this.newHeight = this.oldHeight + this.request.getSizeDelta().height;
        this.parent.getBounds().setSize(this.newWidth, this.newHeight);
        this.parent.getDefaultSize().setSize(this.newWidth, this.newHeight);
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.parent != null) {
            this.parent.getBounds().setSize(this.oldWidth, this.oldHeight);
            this.parent.getDefaultSize().setSize(this.oldWidth, this.oldHeight);
        }
        return super.doUndo(monitor, info);
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.parent != null && this.newHeight != -1) {
            this.parent.getBounds().setSize(this.newWidth, this.newHeight);
            this.parent.getDefaultSize().setSize(this.newWidth, this.newHeight);
        }
        return super.doRedo(monitor, info);
    }
}

