/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.registries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.gmf.runtime.emf.type.core.ClientContext;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IAdviceBindingDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainMerger;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.AdviceConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredAdvice;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredType;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.Activator;
import org.eclipse.papyrus.infra.types.core.registries.AdviceConfigurationTypeRegistry;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeConfigurationTypeRegistry;
import org.eclipse.papyrus.infra.types.core.utils.ElementTypeRegistryUtils;
import org.eclipse.papyrus.infra.types.core.utils.OrientedGraph;
import org.eclipse.papyrus.infra.types.core.utils.TypesConfigurationsCycleUtil;
import org.osgi.framework.Bundle;

public class ElementTypeSetConfigurationRegistry {
    private static volatile ElementTypeSetConfigurationRegistry elementTypeSetConfigurationRegistry;
    protected Set<IClientContext> clientContexts = null;
    protected Map<String, Map<String, ElementTypeSetConfiguration>> elementTypeSetConfigurations = null;
    protected Map<String, Map<String, OrientedGraph<String>>> advicesDeps = null;
    protected ResourceSet elementTypeSetConfigurationResourceSet = this.createResourceSet();

    protected ElementTypeSetConfigurationRegistry() {
        this.listenToArchitectureDomainManager();
    }

    public static synchronized ElementTypeSetConfigurationRegistry getInstance() {
        if (elementTypeSetConfigurationRegistry == null) {
            elementTypeSetConfigurationRegistry = new ElementTypeSetConfigurationRegistry();
            elementTypeSetConfigurationRegistry.init();
        }
        return elementTypeSetConfigurationRegistry;
    }

    protected void init() {
        this.elementTypeSetConfigurations = new HashMap<String, Map<String, ElementTypeSetConfiguration>>();
        this.advicesDeps = new HashMap<String, Map<String, OrientedGraph<String>>>();
        this.clientContexts = new HashSet<IClientContext>();
        Map<String, Set<ElementTypeSetConfiguration>> elementTypeSetConfigurationsToLoad = this.readElementTypeSetConfigurationModelsFromExtensionPoints();
        this.readElementTypeSetConfigurationModelsFromArchitectureDomainManager(elementTypeSetConfigurationsToLoad);
        for (String contexId : elementTypeSetConfigurationsToLoad.keySet()) {
            this.loadElementTypeSetConfigurations(contexId, (Collection<ElementTypeSetConfiguration>)elementTypeSetConfigurationsToLoad.get(contexId));
        }
    }

    protected Map<String, Set<ElementTypeSetConfiguration>> readElementTypeSetConfigurationModels() {
        return new HashMap<String, Set<ElementTypeSetConfiguration>>();
    }

    public synchronized void dispose() {
        if (this.elementTypeSetConfigurations == null) {
            return;
        }
        for (String contextId : this.elementTypeSetConfigurations.keySet()) {
            ClientContext context = (ClientContext)ClientContextManager.getInstance().getClientContext(contextId);
            for (ElementTypeSetConfiguration elementTypeSet : this.elementTypeSetConfigurations.get(contextId).values()) {
                for (AbstractAdviceBindingConfiguration adviceBindingConfiguration : elementTypeSet.getAllAdviceBindings()) {
                    if (adviceBindingConfiguration instanceof ExternallyRegisteredAdvice) {
                        context.unbindId(adviceBindingConfiguration.getIdentifier());
                        continue;
                    }
                    IAdviceBindingDescriptor editHelperAdviceDecriptor = AdviceConfigurationTypeRegistry.getInstance().getEditHelperAdviceDecriptor(adviceBindingConfiguration);
                    ElementTypeRegistryUtils.removeAdviceDescriptorFromBindings(editHelperAdviceDecriptor);
                    context.unbindId(editHelperAdviceDecriptor.getId());
                }
            }
        }
        ArrayList<IElementType> elementTypes = new ArrayList<IElementType>();
        ElementTypeRegistry registry = ElementTypeRegistry.getInstance();
        for (String contextId : this.elementTypeSetConfigurations.keySet()) {
            ClientContext context = (ClientContext)ClientContextManager.getInstance().getClientContext(contextId);
            for (ElementTypeSetConfiguration elementTypeSet : this.elementTypeSetConfigurations.get(contextId).values()) {
                for (ElementTypeConfiguration elementTypeConfiguration : elementTypeSet.getElementTypeConfigurations()) {
                    if (elementTypeConfiguration instanceof ExternallyRegisteredType) {
                        context.unbindId(elementTypeConfiguration.getIdentifier());
                        continue;
                    }
                    String configIdentifier = elementTypeConfiguration.getIdentifier();
                    IElementType elementType = registry.getType(configIdentifier);
                    if (elementType == null) continue;
                    elementTypes.add(elementType);
                }
            }
        }
        ElementTypeUtil.deregisterElementTypes(elementTypes, (int)6);
        for (IClientContext clientContext : this.clientContexts) {
            ClientContextManager.getInstance().deregisterClientContext(clientContext);
        }
        for (Resource resource : new ArrayList(this.elementTypeSetConfigurationResourceSet.getResources())) {
            resource.unload();
            this.elementTypeSetConfigurationResourceSet.getResources().remove((Object)resource);
        }
        this.elementTypeSetConfigurations.clear();
        this.advicesDeps.clear();
        this.clientContexts.clear();
    }

    public boolean loadElementTypeSetConfiguration(String contextId, String path) {
        if (path == null) {
            Activator.log.warn("Path must not be null" + path);
            return false;
        }
        if (contextId == null) {
            Activator.log.warn("contextId must not be null" + path);
            return false;
        }
        URI localURI = URI.createPlatformResourceURI((String)path, (boolean)true);
        Resource resource = this.elementTypeSetConfigurationResourceSet.createResource(localURI);
        boolean registration = true;
        try {
            resource.load(null);
            EObject content = (EObject)resource.getContents().get(0);
            registration = content instanceof ElementTypeSetConfiguration ? this.loadElementTypeSetConfiguration(contextId, (ElementTypeSetConfiguration)content) : false;
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
            registration = false;
        }
        if (!registration) {
            resource.unload();
            this.elementTypeSetConfigurationResourceSet.getResources().remove((Object)resource);
        }
        return registration;
    }

    public boolean loadElementTypeSetConfiguration(String clientContextID, ElementTypeSetConfiguration elementTypeSetConfiguration) {
        return this.loadElementTypeSetConfigurations(clientContextID, Collections.singleton(elementTypeSetConfiguration));
    }

    public OrientedGraph<String> getAdvicesDeps(String elementTypeID, String clientContextID) {
        OrientedGraph<String> dependencies;
        Map<String, OrientedGraph<String>> allDependencies = this.advicesDeps.get(clientContextID);
        if (allDependencies == null) {
            allDependencies = new HashMap<String, OrientedGraph<String>>();
            this.advicesDeps.put(clientContextID, allDependencies);
        }
        if ((dependencies = allDependencies.get(elementTypeID)) == null) {
            dependencies = new OrientedGraph();
            allDependencies.put(elementTypeID, dependencies);
        }
        return dependencies;
    }

    protected boolean isAlreadyRegistred(String elementTypeID, IClientContext context) {
        if (ElementTypeRegistry.getInstance().getType(elementTypeID) != null) {
            if (!elementTypeID.equals("org.eclipse.gmf.runtime.emf.type.core.null") && ElementTypeRegistryUtils.getType(context, elementTypeID) == null) {
                context.bindId(elementTypeID);
            }
            return true;
        }
        return false;
    }

    protected boolean registerElementTypeConfiguration(ElementTypeConfiguration elementTypeConfiguration, Map<String, ElementTypeConfiguration> elementTypeConfigurationsDefinitions, IClientContext context) {
        IElementType elementType;
        String elementTypeID = elementTypeConfiguration.getIdentifier();
        if (this.isAlreadyRegistred(elementTypeID, context)) {
            return true;
        }
        if (elementTypeConfiguration instanceof SpecializationTypeConfiguration) {
            for (ElementTypeConfiguration specializedTypeConfiguration : ((SpecializationTypeConfiguration)elementTypeConfiguration).getSpecializedTypes()) {
                boolean registred;
                if (specializedTypeConfiguration == null || this.isAlreadyRegistred(specializedTypeConfiguration.getIdentifier(), context) || (registred = this.registerElementTypeConfiguration(specializedTypeConfiguration, elementTypeConfigurationsDefinitions, context))) continue;
                Activator.log.info("Failed to register " + specializedTypeConfiguration);
                return false;
            }
        }
        if ((elementType = ElementTypeConfigurationTypeRegistry.getInstance().getElementType(elementTypeConfiguration)) != null) {
            if (elementType instanceof ISpecializationType) {
                if (ElementTypeRegistry.getInstance().register((ISpecializationType)elementType)) {
                    context.bindId(elementType.getId());
                    return true;
                }
                Activator.log.info("SpecializationType not added: " + elementType);
            } else if (elementType instanceof IMetamodelType) {
                if (ElementTypeRegistry.getInstance().register((IMetamodelType)elementType)) {
                    context.bindId(elementType.getId());
                    return true;
                }
                Activator.log.info("MetamodelType not added: " + elementType);
                ElementTypeRegistry.getInstance().register((IMetamodelType)elementType);
            }
        }
        Activator.log.info("Couldn't create ElementType from: " + elementTypeConfiguration);
        return false;
    }

    public boolean loadElementTypeSetConfigurations(String contextId, Collection<ElementTypeSetConfiguration> elementTypeSetConfigurationsToRegister) {
        EObject element;
        TreeIterator it;
        if (contextId == null) {
            Activator.log.warn("contexId must not be null. Loading aborted. ");
            return false;
        }
        IClientContext context = ClientContextManager.getInstance().getClientContext(contextId);
        if (context == null) {
            context = new ClientContext(contextId, new IElementMatcher(){

                public boolean matches(EObject eObject) {
                    return true;
                }
            });
            ClientContextManager.getInstance().registerClientContext(context);
            this.clientContexts.add(context);
        }
        HashMap<String, ElementTypeConfiguration> elementTypeConfigurationsDefinitions = new HashMap<String, ElementTypeConfiguration>();
        HashSet<ElementTypeSetConfiguration> registrableElementTypeSetConfiguration = new HashSet<ElementTypeSetConfiguration>();
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : elementTypeSetConfigurationsToRegister) {
            if (elementTypeSetConfiguration == null) {
                Activator.log.warn("The collection of elementTypesconfigurations contains a null value. Loading aborted. ");
                return false;
            }
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)elementTypeSetConfiguration, Map.of("org.eclipse.papyrus.infra.types.registry_loading", true));
            if (diagnostic.getSeverity() < 4) {
                if (this.elementTypeSetConfigurations.containsKey(elementTypeSetConfiguration.getIdentifier())) {
                    Activator.log.warn("The following ElementTypesSetConfiguration has been ignored because the same ID already registreted: " + elementTypeSetConfiguration.getIdentifier());
                } else {
                    registrableElementTypeSetConfiguration.add(elementTypeSetConfiguration);
                    for (ElementTypeConfiguration elementTypeConfiguration : elementTypeSetConfiguration.getElementTypeConfigurations()) {
                        elementTypeConfigurationsDefinitions.put(elementTypeConfiguration.getIdentifier(), elementTypeConfiguration);
                    }
                }
            }
            if (diagnostic.getSeverity() < 2) continue;
            StringBuilder logMessage = new StringBuilder(diagnostic.getMessage());
            for (Object childDiagnostic : diagnostic.getChildren()) {
                switch (childDiagnostic.getSeverity()) {
                    case 2: 
                    case 4: {
                        logMessage.append(System.lineSeparator()).append("\t");
                        logMessage.append(childDiagnostic.getSeverity() == 2 ? "Warning: " : "Error  : ");
                        logMessage.append(childDiagnostic.getMessage());
                    }
                }
            }
            if (diagnostic.getSeverity() == 2) {
                Activator.log.warn(logMessage.toString());
                continue;
            }
            Activator.log.error(logMessage.toString(), null);
        }
        HashSet<ElementTypeConfiguration> elementTypesToCheck = new HashSet<ElementTypeConfiguration>();
        if (this.elementTypeSetConfigurations.containsKey(contextId)) {
            for (ElementTypeSetConfiguration elementTypeSetConfiguration : this.elementTypeSetConfigurations.get(contextId).values()) {
                elementTypesToCheck.addAll((Collection<ElementTypeConfiguration>)elementTypeSetConfiguration.getElementTypeConfigurations());
            }
        }
        elementTypesToCheck.addAll(elementTypeConfigurationsDefinitions.values());
        OrientedGraph<String> elementTypesDeps = TypesConfigurationsCycleUtil.getDependenciesAmongElementTypes(elementTypesToCheck);
        Collection<Collection<Object>> cyclesElementTypes = TypesConfigurationsCycleUtil.getCyclesAmongElementTypes(elementTypesDeps.getVertices(), elementTypesDeps.getEdges());
        if (!cyclesElementTypes.isEmpty()) {
            Activator.log.warn("The ElementTypesConfiguration registration has been aborted because there is at least a cyclic-dependency in the ElementTypes definitions: " + cyclesElementTypes);
            return false;
        }
        HashSet<AdviceConfiguration> adviceToCheck = new HashSet<AdviceConfiguration>();
        if (this.elementTypeSetConfigurations.containsKey(contextId)) {
            for (ElementTypeSetConfiguration elementTypeSetConfiguration : this.elementTypeSetConfigurations.get(contextId).values()) {
                it = elementTypeSetConfiguration.eAllContents();
                while (it.hasNext()) {
                    element = (EObject)it.next();
                    if (!(element instanceof AdviceConfiguration)) continue;
                    adviceToCheck.add((AdviceConfiguration)element);
                }
            }
        }
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : registrableElementTypeSetConfiguration) {
            it = elementTypeSetConfiguration.eAllContents();
            while (it.hasNext()) {
                element = (EObject)it.next();
                if (!(element instanceof AdviceConfiguration)) continue;
                adviceToCheck.add((AdviceConfiguration)element);
            }
        }
        Map<String, OrientedGraph<String>> deps = TypesConfigurationsCycleUtil.getDependenciesAmongAdvices(adviceToCheck);
        for (String type : deps.keySet()) {
            Collection<Collection<Object>> cyclesAdvices = TypesConfigurationsCycleUtil.getCyclesInAdvices(deps.get(type).getVertices(), deps.get(type).getEdges());
            if (cyclesAdvices.isEmpty()) continue;
            Activator.log.warn("The ElementTypesConfiguration registration has been aborted because there is at least a cyclic-dependencies in the Advices definitions: " + cyclesAdvices);
            return false;
        }
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : registrableElementTypeSetConfiguration) {
            if (!this.elementTypeSetConfigurations.containsKey(contextId)) {
                this.elementTypeSetConfigurations.put(contextId, new HashMap());
            }
            this.elementTypeSetConfigurations.get(contextId).put(elementTypeSetConfiguration.getIdentifier(), elementTypeSetConfiguration);
        }
        for (ElementTypeConfiguration elementTypeConfiguration : elementTypeConfigurationsDefinitions.values()) {
            this.registerElementTypeConfiguration(elementTypeConfiguration, elementTypeConfigurationsDefinitions, context);
        }
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : registrableElementTypeSetConfiguration) {
            EList adviceBindingConfigurations = elementTypeSetConfiguration.getAllAdviceBindings();
            for (AbstractAdviceBindingConfiguration adviceBindingConfiguration : adviceBindingConfigurations) {
                if (adviceBindingConfiguration instanceof ExternallyRegisteredAdvice) {
                    context.bindId(adviceBindingConfiguration.getIdentifier());
                    continue;
                }
                IAdviceBindingDescriptor editHelperAdviceDecriptor = AdviceConfigurationTypeRegistry.getInstance().getEditHelperAdviceDecriptor(adviceBindingConfiguration);
                ElementTypeRegistryUtils.registerAdviceBinding(editHelperAdviceDecriptor);
                context.bindId(editHelperAdviceDecriptor.getId());
            }
        }
        this.advicesDeps.put(contextId, deps);
        return !registrableElementTypeSetConfiguration.isEmpty();
    }

    public boolean unload(String contextId, String elementTypeSetId) {
        Resource resource;
        if (this.elementTypeSetConfigurations == null) {
            return false;
        }
        if (!this.elementTypeSetConfigurations.containsKey(contextId)) {
            return false;
        }
        Map<String, ElementTypeSetConfiguration> map = this.elementTypeSetConfigurations.get(contextId);
        ElementTypeSetConfiguration elementTypeSet = map.remove(elementTypeSetId);
        if (elementTypeSet == null) {
            return false;
        }
        ElementTypeRegistry registry = ElementTypeRegistry.getInstance();
        ArrayList<IElementType> elementTypes = new ArrayList<IElementType>(elementTypeSet.getElementTypeConfigurations().size());
        for (ElementTypeConfiguration elementTypeConfiguration : elementTypeSet.getElementTypeConfigurations()) {
            Object configIdentifier;
            IElementType elementType;
            if (elementTypeConfiguration == null || elementTypeConfiguration.getIdentifier() == null || (elementType = registry.getType((String)(configIdentifier = elementTypeConfiguration.getIdentifier()))) == null) continue;
            elementTypes.add(elementType);
        }
        ElementTypeUtil.deregisterElementTypes(elementTypes, (int)7);
        EList adviceBindingConfigurations = elementTypeSet.getAllAdviceBindings();
        for (AbstractAdviceBindingConfiguration adviceBindingConfiguration : adviceBindingConfigurations) {
            IAdviceBindingDescriptor advice = AdviceConfigurationTypeRegistry.getInstance().getEditHelperAdviceDecriptor(adviceBindingConfiguration);
            if (advice == null) continue;
            ElementTypeRegistryUtils.removeAdviceDescriptorFromBindings(advice);
        }
        if (this.elementTypeSetConfigurationResourceSet != null && (resource = elementTypeSet.eResource()) != null && resource.getResourceSet() == this.elementTypeSetConfigurationResourceSet) {
            resource.unload();
            this.elementTypeSetConfigurationResourceSet.getResources().remove((Object)resource);
        }
        HashSet<AdviceConfiguration> advices = new HashSet<AdviceConfiguration>();
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : this.elementTypeSetConfigurations.get(contextId).values()) {
            TreeIterator it = elementTypeSetConfiguration.eAllContents();
            while (it.hasNext()) {
                EObject element = (EObject)it.next();
                if (!(element instanceof AdviceConfiguration)) continue;
                advices.add((AdviceConfiguration)element);
            }
        }
        Map<String, OrientedGraph<String>> deps = TypesConfigurationsCycleUtil.getDependenciesAmongAdvices(advices);
        this.advicesDeps.put(contextId, deps);
        return true;
    }

    protected void addElementTypeSetConfigurationToDefinitions(ElementTypeSetConfiguration set, String clientContextId, Map<String, Set<ElementTypeSetConfiguration>> existingDefinitions) {
        if (set != null) {
            if (set.getIdentifier() == null) {
                Activator.log.warn("The following ElementTypesSetConfiguration has ill-defined ID and is therefore ignored: " + set.eResource().getURI());
            } else if (existingDefinitions.get(clientContextId) != null && this.containsElementTypeSet(existingDefinitions.get(clientContextId), set.getIdentifier())) {
                Activator.log.warn("The following ElementTypesSetConfiguration has been ignored because the same ID already registreted: " + set.getIdentifier());
            } else {
                if (!existingDefinitions.containsKey(clientContextId)) {
                    existingDefinitions.put(clientContextId, new HashSet());
                }
                existingDefinitions.get(clientContextId).add(set);
            }
        }
    }

    protected Map<String, Set<ElementTypeSetConfiguration>> readElementTypeSetConfigurationModelsFromExtensionPoints() {
        IConfigurationElement[] elements;
        HashMap<String, Set<ElementTypeSetConfiguration>> existingDefinitions = new HashMap<String, Set<ElementTypeSetConfiguration>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ElementTypeSetConfiguration set;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String modelPath = element.getAttribute("path");
            String clientContextId = element.getAttribute("clientContextID");
            String contributorID = element.getContributor().getName();
            if (Platform.inDebugMode()) {
                Activator.log.debug("[Reading extension point]");
                Activator.log.debug("-  Path to the model: " + modelPath);
                Activator.log.debug("-  ClientContext the model will be registreted to: " + clientContextId);
                Activator.log.debug("-  id of the container bundle: " + contributorID);
            }
            if ((set = this.getElementTypeSetConfiguration(modelPath, contributorID)) != null) {
                this.addElementTypeSetConfigurationToDefinitions(set, clientContextId, existingDefinitions);
            }
            ++n2;
        }
        return existingDefinitions;
    }

    protected void readElementTypeSetConfigurationModelsFromArchitectureDomainManager(Map<String, Set<ElementTypeSetConfiguration>> map) {
        ArchitectureDomainMerger merger = ArchitectureDomainManager.getInstance().getMerger();
        for (MergedArchitectureDomain domain : merger.getDomains()) {
            for (MergedArchitectureContext context : domain.getContexts()) {
                Set<ElementTypeSetConfiguration> set = map.get(context.getId());
                if (set == null) {
                    set = new HashSet<ElementTypeSetConfiguration>();
                    map.put(context.getId(), set);
                }
                set.addAll(context.getElementTypes());
            }
        }
    }

    protected void listenToArchitectureDomainManager() {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        manager.addListener((ArchitectureDomainManager.Listener)new ArchitectureDomainManager.SpecificListener(){

            public void addedModelsChanged() {
                ElementTypeSetConfigurationRegistry.this.dispose();
                ElementTypeSetConfigurationRegistry.this.init();
            }
        });
    }

    protected boolean containsElementTypeSet(Set<ElementTypeSetConfiguration> elementTypeSets, String elementTypeSetConfigurationId) {
        if (elementTypeSets == null) {
            return false;
        }
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : elementTypeSets) {
            if (!elementTypeSetConfiguration.getIdentifier().equals(elementTypeSetConfigurationId)) continue;
            return true;
        }
        return false;
    }

    protected ElementTypeSetConfiguration getElementTypeSetConfiguration(String modelPath, String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (Platform.isFragment((Bundle)bundle)) {
            ElementTypeSetConfiguration configuration = this.getElementTypeSetConfigurationInBundle(modelPath, bundleId);
            if (configuration == null) {
                Activator.log.warn("Cannot find resource " + modelPath + " in bundle " + bundleId);
            }
            return configuration;
        }
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        if (fragments == null) {
            return this.getElementTypeSetConfigurationInBundle(modelPath, bundleId);
        }
        ElementTypeSetConfiguration elementTypeSetConfiguration = null;
        Bundle[] bundleArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            elementTypeSetConfiguration = this.getElementTypeSetConfigurationInBundle(modelPath, fragment.getSymbolicName());
            if (elementTypeSetConfiguration != null) break;
            ++n2;
        }
        if (elementTypeSetConfiguration == null) {
            elementTypeSetConfiguration = this.getElementTypeSetConfigurationInBundle(modelPath, bundleId);
        }
        if (elementTypeSetConfiguration == null) {
            Activator.log.warn("Cannot find resource " + modelPath + " in bundle " + bundleId);
        }
        return elementTypeSetConfiguration;
    }

    protected ElementTypeSetConfiguration getElementTypeSetConfigurationInBundle(String modelPath, String bundleID) {
        String path = String.valueOf(bundleID) + '/' + modelPath;
        Resource resource = this.elementTypeSetConfigurationResourceSet.createResource(URI.createPlatformPluginURI((String)path, (boolean)true));
        try {
            resource.load(null);
        }
        catch (IOException e) {
            return null;
        }
        EObject content = (EObject)resource.getContents().get(0);
        if (content instanceof ElementTypeSetConfiguration) {
            return (ElementTypeSetConfiguration)content;
        }
        return null;
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    public Map<String, Map<String, ElementTypeSetConfiguration>> getElementTypeSetConfigurations() {
        return this.elementTypeSetConfigurations;
    }
}

