/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class OccurrenceSpecificationUtil {
    public static CreateRelationshipRequest getCreateRelationshipRequest(CreateConnectionRequest request) {
        if (!(request instanceof CreateConnectionViewAndElementRequest)) {
            return null;
        }
        CreateElementRequestAdapter requestAdapter = ((CreateConnectionViewAndElementRequest)request).getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
        if (requestAdapter == null) {
            return null;
        }
        CreateRelationshipRequest createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class);
        return createElementRequest;
    }

    public static boolean isStart(IFigure targetFigure, CreateRequest createRequest) {
        return OccurrenceSpecificationUtil.isStart(targetFigure, createRequest.getLocation());
    }

    public static boolean isStart(IFigure targetFigure, Point requestLocation) {
        Rectangle bounds = targetFigure.getBounds().getCopy();
        targetFigure.translateToAbsolute((Translatable)bounds);
        double distanceToTop = requestLocation.getDistance(bounds.getTop());
        double distanceToBottom = requestLocation.getDistance(bounds.getBottom());
        return distanceToTop < distanceToBottom;
    }

    public static boolean isSource(IFigure targetFigure, CreateRequest createRequest) {
        return OccurrenceSpecificationUtil.isSource(targetFigure, createRequest.getLocation());
    }

    public static boolean isSource(IFigure targetFigure, Point requestLocation) {
        requestLocation = requestLocation.getCopy();
        IFigure connection = targetFigure;
        if (connection instanceof Connection) {
            PointList points = ((Connection)connection).getPoints();
            connection.translateToRelative((Translatable)requestLocation);
            if (points.size() >= 2) {
                double distanceToTarget;
                Point source = points.getFirstPoint();
                Point target = points.getLastPoint();
                double distanceToSource = requestLocation.getDistance(source);
                return distanceToSource < (distanceToTarget = requestLocation.getDistance(target));
            }
        }
        return true;
    }

    public static OccurrenceSpecification findSemanticOccurrence(View connectorEnd, String anchorTerminal) {
        block23: {
            EObject semantic;
            block21: {
                semantic = connectorEnd.getElement();
                if (semantic instanceof OccurrenceSpecification) {
                    return (OccurrenceSpecification)semantic;
                }
                if (!(semantic instanceof ExecutionSpecification)) break block21;
                switch (anchorTerminal) {
                    case "start": {
                        return ((ExecutionSpecification)semantic).getStart();
                    }
                    case "end": {
                        return ((ExecutionSpecification)semantic).getFinish();
                    }
                }
                return null;
            }
            if (!(semantic instanceof Message)) break block23;
            switch (anchorTerminal) {
                case "start": {
                    MessageEnd sendEvent = ((Message)semantic).getSendEvent();
                    return sendEvent instanceof OccurrenceSpecification ? (OccurrenceSpecification)sendEvent : null;
                }
                case "end": {
                    MessageEnd receiveEvent = ((Message)semantic).getReceiveEvent();
                    return receiveEvent instanceof OccurrenceSpecification ? (OccurrenceSpecification)receiveEvent : null;
                }
            }
            return null;
        }
        return null;
    }

    public static EObject getOccurrence(ReconnectRequest request) {
        EObject element = EMFHelper.getEObject((Object)request.getTarget());
        IFigure targetFigure = ((IGraphicalEditPart)request.getTarget()).getFigure();
        if (element instanceof Message) {
            if (OccurrenceSpecificationUtil.isSource(targetFigure, request.getLocation())) {
                return ((Message)element).getSendEvent();
            }
            return ((Message)element).getReceiveEvent();
        }
        if (element instanceof ExecutionSpecification) {
            if (OccurrenceSpecificationUtil.isStart(targetFigure, request.getLocation())) {
                return ((ExecutionSpecification)element).getStart();
            }
            return ((ExecutionSpecification)element).getFinish();
        }
        return element;
    }

    public static EObject getSourceOccurrence(Edge connection) {
        Anchor sourceAnchor = connection.getSourceAnchor();
        if (sourceAnchor instanceof IdentityAnchor) {
            return OccurrenceSpecificationUtil.findSemanticOccurrence(connection.getSource(), ((IdentityAnchor)sourceAnchor).getId());
        }
        return connection.getSource().getElement();
    }

    public static EObject getTargetOccurrence(Edge connection) {
        Anchor targetAnchor = connection.getTargetAnchor();
        if (targetAnchor instanceof IdentityAnchor) {
            return OccurrenceSpecificationUtil.findSemanticOccurrence(connection.getTarget(), ((IdentityAnchor)targetAnchor).getId());
        }
        return connection.getTarget().getElement();
    }
}

