/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectColumnCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

public class SelectColumnCommandHandler
implements ILayerCommandHandler<SelectColumnCommand> {
    private final SelectionLayer selectionLayer;

    public SelectColumnCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectColumnCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.selectColumn(command.getColumnPosition(), command.getRowPosition(), command.isWithShiftMask(), command.isWithControlMask());
            return true;
        }
        return false;
    }

    protected void selectColumn(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        if (SelectionUtils.noShiftOrControl(withShiftMask, withControlMask)) {
            this.selectionLayer.clear(false);
            this.selectionLayer.selectCell(columnPosition, 0, false, false);
            this.selectionLayer.selectRegion(columnPosition, 0, 1, Integer.MAX_VALUE);
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        } else if (SelectionUtils.bothShiftAndControl(withShiftMask, withControlMask)) {
            this.selectColumnWithShiftKey(columnPosition);
        } else if (SelectionUtils.isShiftOnly(withShiftMask, withControlMask)) {
            this.selectColumnWithShiftKey(columnPosition);
        } else if (SelectionUtils.isControlOnly(withShiftMask, withControlMask)) {
            this.selectColumnWithCtrlKey(columnPosition, rowPosition);
        }
        this.selectionLayer.setLastSelectedCell(columnPosition, rowPosition);
        this.selectionLayer.fireLayerEvent(new ColumnSelectionEvent(this.selectionLayer, columnPosition, withShiftMask, withControlMask));
    }

    private void selectColumnWithCtrlKey(int columnPosition, int rowPosition) {
        Rectangle selectedColumnRectangle = new Rectangle(columnPosition, 0, 1, Integer.MAX_VALUE);
        if (this.selectionLayer.isColumnPositionFullySelected(columnPosition)) {
            this.selectionLayer.clearSelection(selectedColumnRectangle);
            if (this.selectionLayer.getLastSelectedRegion() != null && this.selectionLayer.getLastSelectedRegion().equals((Object)selectedColumnRectangle)) {
                this.selectionLayer.setLastSelectedRegion(null);
            }
        } else {
            if (this.selectionLayer.getLastSelectedRegion() != null) {
                this.selectionLayer.selectionModel.addSelection(new Rectangle(this.selectionLayer.getLastSelectedRegion().x, this.selectionLayer.getLastSelectedRegion().y, this.selectionLayer.getLastSelectedRegion().width, this.selectionLayer.getLastSelectedRegion().height));
            }
            this.selectionLayer.selectRegion(columnPosition, 0, 1, Integer.MAX_VALUE);
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        }
    }

    private void selectColumnWithShiftKey(int columnPosition) {
        int numOfColumnsToIncludeInRegion = 1;
        int startColumnPosition = columnPosition;
        if (!this.selectionLayer.getSelectionModel().isMultipleSelectionAllowed()) {
            this.selectionLayer.getSelectionAnchor().columnPosition = columnPosition;
        }
        if (this.selectionLayer.getLastSelectedRegion() != null) {
            numOfColumnsToIncludeInRegion = Math.abs(this.selectionLayer.getSelectionAnchor().columnPosition - columnPosition) + 1;
            startColumnPosition = columnPosition < this.selectionLayer.getSelectionAnchor().columnPosition ? columnPosition : this.selectionLayer.getSelectionAnchor().columnPosition;
        }
        this.selectionLayer.selectRegion(startColumnPosition, 0, numOfColumnsToIncludeInRegion, Integer.MAX_VALUE);
    }

    @Override
    public Class<SelectColumnCommand> getCommandClass() {
        return SelectColumnCommand.class;
    }
}

