/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.multipage.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IComponentModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

@Deprecated
public abstract class MultiPageEditor
extends MultiPageEditorPart {
    private ISashWindowsContentProvider pageProvider;
    private ITabFolderModel tabFolderModel;
    protected List<IPageModel> currentTabs = new ArrayList<IPageModel>();

    protected void initializePageSwitching() {
        super.initializePageSwitching();
        this.activate();
    }

    protected void activate() {
    }

    protected void deactivate() {
    }

    public void dispose() {
        this.deactivate();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (ISashWindowsContentProvider.class == adapter) {
            return this.getContentProvider();
        }
        return super.getAdapter(adapter);
    }

    protected ISashWindowsContentProvider getContentProvider() {
        if (this.pageProvider == null) {
            this.pageProvider = this.createPageProvider();
        }
        return this.pageProvider;
    }

    protected void setContentProvider(ISashWindowsContentProvider pageProvider) {
        this.pageProvider = pageProvider;
    }

    protected int addPage(IComponentModel tabItem) {
        Composite composite = tabItem.createPartControl(this.getContainer());
        int index = this.addPage((Control)composite);
        this.setPageText(index, tabItem.getTabTitle());
        Image image = tabItem.getTabIcon();
        if (image != null) {
            this.setPageImage(index, image);
        }
        return index;
    }

    protected int addPage(IEditorModel editorModel) {
        try {
            IEditorPart editor = editorModel.createIEditorPart();
            int index = this.addPage(editor, this.getEditorInput());
            this.setPageText(index, editorModel.getTabTitle());
            Image image = editorModel.getTabIcon();
            if (image != null) {
                this.setPageImage(index, image);
            }
            return index;
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
            return -1;
        }
    }

    protected void createPages() {
        this.pageProvider = this.getContentProvider();
        this.tabFolderModel = this.lookupFolder();
        this.refreshTabs();
    }

    private ITabFolderModel lookupFolder() {
        if (this.pageProvider == null) {
            return null;
        }
        Object rawModel = this.pageProvider.getRootModel();
        IAbstractPanelModel panelModel = this.pageProvider.createChildSashModel(rawModel);
        return this.lookupFolder(panelModel);
    }

    private ITabFolderModel lookupFolder(IAbstractPanelModel panelModel) {
        if (panelModel instanceof ITabFolderModel) {
            return (ITabFolderModel)panelModel;
        }
        ISashPanelModel sashModel = (ISashPanelModel)panelModel;
        for (Object child : sashModel.getChildren()) {
            IAbstractPanelModel childModel = this.pageProvider.createChildSashModel(child);
            ITabFolderModel res = this.lookupFolder(childModel);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    protected abstract ISashWindowsContentProvider createPageProvider();

    protected void refreshTabs() {
        List<?> newModels = this.tabFolderModel.getChildren();
        for (Object model : newModels) {
            IPageModel pageModel;
            if (this.tabExistsFor(model) || (pageModel = this.tabFolderModel.createChildSashModel(model)) == null) continue;
            this.addEditor(pageModel);
        }
        if (newModels.size() == this.getPageCount()) {
            return;
        }
        ArrayList<IPageModel> toBeRemoved = new ArrayList<IPageModel>();
        for (IPageModel model : this.currentTabs) {
            if (newModels.contains(model.getRawModel())) continue;
            toBeRemoved.add(model);
        }
        for (IPageModel model : toBeRemoved) {
            this.removeEditor(model);
        }
    }

    private boolean tabExistsFor(Object model) {
        for (IPageModel tabItem : this.currentTabs) {
            if (tabItem.getRawModel() != model) continue;
            return true;
        }
        return false;
    }

    public void removePage(int pageIndex) {
        super.removePage(pageIndex);
        this.currentTabs.remove(pageIndex);
    }

    private void removeEditor(IPageModel model) {
        int index = this.currentTabs.indexOf(model);
        this.removePage(index);
    }

    private void addEditor(IPageModel tabItem) {
        if (this.tabExistsFor(tabItem)) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug("Editor already exists for '" + tabItem + "'");
            }
            return;
        }
        int editorIndex = -1;
        if (tabItem instanceof IEditorModel) {
            editorIndex = this.addPage((IEditorModel)tabItem);
        } else if (tabItem instanceof IComponentModel) {
            editorIndex = this.addPage((IComponentModel)tabItem);
        } else {
            System.err.println("Can't create page for model '" + tabItem + "'. Skipp it.");
            return;
        }
        this.currentTabs.add(tabItem);
        this.setActivePage(editorIndex);
    }
}

