/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.lang.reflect.Constructor;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.AbstractPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.IGraphicalEditorSupport;
import org.eclipse.papyrus.infra.gmfdiag.common.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.NotationLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.ui.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public class GmfEditorFactory
extends AbstractEditorFactory {
    protected GmfEditorFactory(Class<?> diagramClass, String expectedType) {
        super(diagramClass, expectedType);
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        Diagram diagram;
        if (pageIdentifier instanceof Diagram && !(diagram = (Diagram)pageIdentifier).eIsProxy()) {
            String type = diagram.getType();
            return this.getExpectedType().equals(type);
        }
        return false;
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        ServicesRegistry services = this.getServiceRegistry();
        ILabelProvider labels = ServiceUtils.getInstance().tryService((Object)services, LabelProviderService.class).map(lps -> lps.getLabelProvider(pageIdentifier)).orElseGet(NotationLabelProvider::new);
        return new GMFEditorModel((Diagram)pageIdentifier, services, labels);
    }

    class GMFEditorModel
    extends AbstractPageModel
    implements IEditorModel {
        private Diagram diagram;
        private ServicesRegistry servicesRegistry;

        public GMFEditorModel(Diagram pageIdentifier, ServicesRegistry servicesRegistry, ILabelProvider labels) {
            super(labels);
            this.diagram = pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                Constructor c = GmfEditorFactory.this.getDiagramClass().getConstructor(ServicesRegistry.class, Diagram.class);
                GraphicalEditor editor = (GraphicalEditor)c.newInstance(this.servicesRegistry, this.diagram);
                IGraphicalEditorSupport editorSupport = (IGraphicalEditorSupport)this.servicesRegistry.getService(IGraphicalEditorSupport.class);
                editorSupport.initialize(editor);
                return editor;
            }
            catch (Exception e) {
                throw new PartInitException(String.valueOf(Messages.GmfEditorFactory_ErrorCreatingEditorPart) + this.diagram, (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = GmfEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.diagram;
        }
    }
}

