/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.ui.properties.widgets;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.papyrus.infra.emf.types.ui.properties.widgets.FeatureNameValueEditor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.widgets.Composite;

public class FeatureNamePropertyEditor
extends AbstractPropertyEditor {
    private FeatureNameValueEditor editor;
    private AdapterFactoryEditingDomain domain;
    private static final String SOURCE_ECLASS = "sourceEClass";

    public FeatureNamePropertyEditor(Composite parent, int style) {
        this.editor = new FeatureNameValueEditor(parent, style);
        this.setEditor((AbstractValueEditor)this.editor);
    }

    protected void setObjectToApply() {
        Object eClassSourceElement;
        if (this.domain != null && (eClassSourceElement = this.domain.getResourceSet().getLoadOptions().get(SOURCE_ECLASS)) instanceof EClass) {
            this.editor.setSourceEClass((EClass)eClassSourceElement);
        }
    }

    public void setProperty(String path) {
        super.setProperty(path);
        this.setDomain();
        this.setObjectToApply();
    }

    public void setInput(DataSource input) {
        super.setInput(input);
        this.setDomain();
        this.setObjectToApply();
    }

    private void setDomain() {
        if (this.propertyPath != null && this.input != null) {
            ModelElement modelElement = this.input.getModelElement(this.propertyPath);
            EMFHelper.resolveEditingDomain((Object)this.input.getSelection().getFirstElement());
            if (modelElement instanceof EMFModelElement) {
                this.domain = (AdapterFactoryEditingDomain)((EMFModelElement)modelElement).getDomain();
            }
        }
    }
}

