/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.ui.properties.modelelements;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.types.ui.properties.messages.Messages;
import org.eclipse.papyrus.infra.emf.types.ui.properties.providers.ViewContentProvider;
import org.eclipse.papyrus.infra.emf.types.ui.properties.providers.ViewLabelProvider;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Profile;

public class RuntimeValuesModelElement
extends EMFModelElement {
    public RuntimeValuesModelElement(EObject sourceElement, EditingDomain domain) {
        super(sourceElement, domain);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        ViewLabelProvider labelProvider = null;
        labelProvider = "view".equals(propertyPath) || "viewsToDisplay".equals(propertyPath) ? new ViewLabelProvider() : super.getLabelProvider(propertyPath);
        return labelProvider;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        ViewContentProvider contentProvider = null;
        contentProvider = "view".equals(propertyPath) ? new ViewContentProvider() : super.getContentProvider(propertyPath);
        return contentProvider;
    }

    public boolean getDirectCreation(String propertyPath) {
        return false;
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        ReferenceValueFactory valueFactory = null;
        if ("view".equals(propertyPath)) {
            valueFactory = new ReferenceValueFactory(){

                public boolean canCreateObject() {
                    return false;
                }

                public boolean canEdit() {
                    return true;
                }

                public Object createObject(Control widget, Object context) {
                    return null;
                }

                public Object edit(Control widget, Object object) {
                    Object[] resultValue;
                    Object newValue = null;
                    TreeSelectorDialog dialog = new TreeSelectorDialog(widget.getShell());
                    dialog.setContentProvider((ITreeContentProvider)new ViewContentProvider());
                    dialog.setLabelProvider((ILabelProvider)new ViewLabelProvider());
                    dialog.setTitle(Messages.RuntimeValuesModelElement_browserTitle);
                    dialog.setDescription(Messages.RuntimeValuesModelElement_browserDescription);
                    int result = dialog.open();
                    if (result == 0 && (resultValue = dialog.getResult()).length > 0) {
                        Object profile = resultValue[0];
                        if (profile instanceof Profile) {
                            newValue = ((Profile)profile).getName();
                        } else if (profile instanceof View) {
                            newValue = profile;
                        }
                    }
                    return newValue;
                }

                public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
                    return objectsToValidate;
                }
            };
        }
        return valueFactory != null ? valueFactory : super.getValueFactory(propertyPath);
    }
}

