/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Activator;
import org.eclipse.papyrus.toolsmiths.plugin.builder.GenericEMFModelBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Messages;
import org.eclipse.papyrus.toolsmiths.plugin.internal.builder.XWTModelBuilderProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class XWTModelBuilder
extends GenericEMFModelBuilder {
    private static final String XWT_URI = "http://www.eclipse.org/xwt";
    private static final String XWT_PRESENTATION_URI = "http://www.eclipse.org/xwt/presentation";

    @Override
    protected Set<String> getModelBundleDependenciesFromXML(Resource resource) {
        Set<String> importedMetamodels_NS_URI = this.getXMLImportedMetamodelNsURI(resource);
        HashSet<String> realURI = new HashSet<String>();
        for (String current : importedMetamodels_NS_URI) {
            String bundleFound = null;
            if (this.isIgnoredNS_URI(current)) continue;
            if (current.startsWith("clr-namespace:")) {
                String substring = current.replaceAll("clr-namespace:", "");
                IPluginModelBase pluginModelBase = PluginRegistry.findModel((String)substring);
                while (pluginModelBase == null && substring.contains(".")) {
                    int lastIndex = substring.lastIndexOf(46);
                    substring = substring.substring(0, lastIndex);
                    pluginModelBase = PluginRegistry.findModel((String)substring);
                }
                if (pluginModelBase != null) {
                    bundleFound = pluginModelBase.getBundleDescription().getName();
                }
            } else {
                bundleFound = XWT_URI.equals(current) || XWT_PRESENTATION_URI.equals(current) ? "org.eclipse.xwt" : this.getBundleNameFromNS_URI(current);
            }
            if (bundleFound != null) continue;
            Activator.log.warn(NLS.bind((String)Messages.XWTModelBuilder_noBundleWithUri, (Object)current));
        }
        return realURI;
    }

    @Override
    protected Set<String> getDependencies(Resource resource, IProject builtProject) {
        EcoreUtil.resolveAll((Resource)resource);
        TreeSet<String> dependencies = new TreeSet<String>();
        for (Resource current : resource.getResourceSet().getResources()) {
            String bundleName = this.getBundleNameFromResource(current);
            if (bundleName != null) {
                dependencies.add(bundleName);
            } else {
                Activator.log.warn(NLS.bind((String)Messages.XWTModelBuilder_noBundleProvidingResourceUri, (Object)resource.getURI()));
            }
            dependencies.addAll(this.getModelBundleDependenciesFromXML(resource));
        }
        return dependencies;
    }

    @Override
    protected String getBundleNameFromResource(Resource resource) {
        URI uri;
        String str = super.getBundleNameFromResource(resource);
        if (str == null && (uri = resource.getURI()).scheme().equals("ppe") && uri.segments()[0].equals("environment")) {
            str = uri.segments()[1];
        }
        return str;
    }

    @Override
    protected boolean managedFileExtension(String fileExtension) {
        return XWTModelBuilderProvider.MODEL_FILE_EXTENSIONS.contains(fileExtension);
    }

    @Override
    protected boolean isIgnoredNS_URI(String ns_URI) {
        return super.isIgnoredNS_URI(ns_URI) || "clr-namespace:java.lang".equals(ns_URI);
    }
}

