/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.internal.ui.runtime.IInternalConfigurationManager;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.views.properties.toolsmiths.Activator;
import org.eclipse.papyrus.views.properties.toolsmiths.storage.actions.IContextDeleteAction;
import org.eclipse.swt.widgets.Display;

public class RemoveContextAction {
    private IContextDeleteAction delegate;

    public RemoveContextAction(IContextDeleteAction delegate) {
        this.delegate = delegate;
    }

    public void removeContext(final Context sourceContext) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IInternalConfigurationManager mgr = (IInternalConfigurationManager)PropertiesRuntime.getConfigurationManager();
                        RemoveContextAction.this.delegate.delete(sourceContext, monitor);
                        mgr.deleteContext(sourceContext);
                    }
                    catch (CoreException ex) {
                        Activator.log.error((Throwable)ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }
}

