/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.ui;

import java.util.Observable;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.gmf.internal.common.ui.Messages;
import org.eclipse.papyrus.gmf.internal.common.ui.ModelSelectionPage;
import org.eclipse.papyrus.gmf.internal.common.ui.ModelSelectionPageExtension;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class CreateNewModelExtension
extends Observable
implements ModelSelectionPageExtension {
    private final ModelSelectionPage page;
    private boolean createNewModel;

    public CreateNewModelExtension(ModelSelectionPage page) {
        this.page = page;
    }

    public final boolean shouldCreateNewModel() {
        return this.createNewModel;
    }

    protected void setCreateNewModel(boolean value) {
        if (this.createNewModel == value) {
            return;
        }
        this.createNewModel = value;
        this.page.setReadOnly(value);
        this.page.validatePage();
        this.setChanged();
        this.notifyObservers(this.createNewModel);
    }

    protected String getLabelText() {
        return Messages.CreateNewModelExtensionCreateNewModel;
    }

    @Override
    public void createControl(Composite parent) {
        final Button btn = new Button(parent, 32);
        btn.setText(this.getLabelText());
        btn.setSelection(this.createNewModel);
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CreateNewModelExtension.this.setCreateNewModel(btn.getSelection());
            }
        });
    }

    @Override
    public void setResource(Resource resource) {
    }

    public void validatePage() {
        if (!this.page.isModelRequired()) {
            return;
        }
        if (this.createNewModel) {
            this.page.setPageComplete(true);
        } else {
            this.page.setPageComplete(this.page.getResource() != null);
        }
    }
}

