/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.reconcile;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.gmf.internal.common.reconcile.Cleaner;
import org.eclipse.papyrus.gmf.internal.common.reconcile.Copier;
import org.eclipse.papyrus.gmf.internal.common.reconcile.Decision;
import org.eclipse.papyrus.gmf.internal.common.reconcile.Matcher;
import org.eclipse.papyrus.gmf.internal.common.reconcile.ReconcilerConfig;
import org.eclipse.papyrus.gmf.internal.common.reconcile.ReflectiveMatcher;

public class ReconcilerConfigBase
implements ReconcilerConfig {
    private static final EClassRecord EMPTY_RECORD = new EClassRecord();
    private final HashMap<EClass, EClassRecord> myEClass2Record = new HashMap();
    private final HashMap<EClass, EClassRecord> myAbstractEClass2SubclassesRecord = new HashMap();
    protected static final Matcher ALWAYS_MATCH = new Matcher(){

        @Override
        public boolean match(EObject current, EObject old) {
            return current.eClass().equals(old.eClass());
        }
    };

    @Override
    public final Matcher getMatcher(EClass eClass) {
        Matcher result = this.getRecord(eClass, false).getMatcher();
        if (result != Matcher.FALSE) {
            return result;
        }
        return this.getExistingRecordFromHierarchy(eClass).getMatcher();
    }

    @Override
    public Copier getCopier(EClass eClass) {
        return this.getRecord(eClass, false).getCopier();
    }

    @Override
    public Cleaner getCleaner(EClass eClass) {
        return this.getRecord(eClass, false).getCleaner();
    }

    @Override
    public final Decision[] getDecisions(EClass eClass) {
        return this.getRecord(eClass, false).getDecisions();
    }

    protected final void setMatcher(EClass eClass, Matcher matcher) {
        this.getRecord(eClass, true).setMatcher(matcher);
    }

    protected final void setMatcher(EClass eClass, EAttribute attribute) {
        ReconcilerConfigBase.checkStructuralFeature(eClass, (EStructuralFeature)attribute);
        this.setMatcher(eClass, new ReflectiveMatcher((EStructuralFeature)attribute));
    }

    protected final void setMatcher(EClass eClass, EReference reference) {
        ReconcilerConfigBase.checkStructuralFeature(eClass, (EStructuralFeature)reference);
        this.setMatcher(eClass, new ReflectiveMatcher((EStructuralFeature)reference));
    }

    protected final void setMatcherForAllSubclasses(EClass eClass, Matcher matcher) {
        ReconcilerConfigBase.checkAbstract(eClass);
        this.getTemplateRecord(eClass, true).setMatcher(matcher);
    }

    protected final void setCopier(EClass eClass, Copier copier) {
        this.getRecord(eClass, true).setCopier(copier);
    }

    protected final void setCopierForAllSubclasses(EClass eClass, Copier copier) {
        ReconcilerConfigBase.checkAbstract(eClass);
        this.getTemplateRecord(eClass, true).setCopier(copier);
    }

    protected final void setCleaner(EClass eClass, Cleaner cleaner) {
        this.getRecord(eClass, true).setCleaner(cleaner);
    }

    protected final void setCleanerForAllSubclasses(EClass eClass, Cleaner cleaner) {
        ReconcilerConfigBase.checkAbstract(eClass);
        this.getTemplateRecord(eClass, true).setCleaner(cleaner);
    }

    private static void checkAbstract(EClass eClass) {
        if (!eClass.isAbstract()) {
            throw new IllegalArgumentException("This is not safe method that may lead to strange behaviour in case of multiple inheritance. We tried to limit its usage as much as possible");
        }
    }

    protected final void addDecision(EClass eClass, Decision decision) {
        this.getRecord(eClass, true).addDecision(decision);
    }

    private EClassRecord getRecord(EClass eClass, boolean force) {
        EClassRecord result = this.myEClass2Record.get(eClass);
        if (result == null) {
            if (force) {
                result = new EClassRecord();
                this.myEClass2Record.put(eClass, result);
            } else {
                result = this.getExistingRecordFromHierarchy(eClass);
                if (result != EMPTY_RECORD) {
                    this.myEClass2Record.put(eClass, result);
                }
            }
        }
        return result;
    }

    private EClassRecord getExistingRecordFromHierarchy(EClass eClass) {
        EClassRecord result = EMPTY_RECORD;
        Iterator superClasses = eClass.getEAllSuperTypes().iterator();
        while (result == EMPTY_RECORD && superClasses.hasNext()) {
            EClass nextSuper = (EClass)superClasses.next();
            if (!nextSuper.isAbstract()) continue;
            result = this.getTemplateRecord(nextSuper, false);
        }
        return result;
    }

    private EClassRecord getTemplateRecord(EClass abstractSuperClass, boolean force) {
        assert (abstractSuperClass.isAbstract());
        EClassRecord result = this.myAbstractEClass2SubclassesRecord.get(abstractSuperClass);
        if (result == null && force) {
            result = new EClassRecord();
            this.myAbstractEClass2SubclassesRecord.put(abstractSuperClass, result);
        }
        return result == null ? EMPTY_RECORD : result;
    }

    private static void checkStructuralFeature(EClass expectedClass, EStructuralFeature feature) {
        if (expectedClass.getEStructuralFeature(feature.getFeatureID()) != feature) {
            throw new IllegalArgumentException(MessageFormat.format("Alien feature {0} for EClass {1}", feature, expectedClass));
        }
    }

    private static class EClassRecord {
        private Matcher myMatcher = Matcher.FALSE;
        private Copier myCopier = Copier.NEVER_COPY;
        private Cleaner myCleaner = new Cleaner();
        private final List<Decision> myDecisions = new LinkedList<Decision>();
        private Decision[] myMakersArray;

        private EClassRecord() {
        }

        public void addDecision(Decision maker) {
            this.myDecisions.add(maker);
            this.makersSetChanged();
        }

        public void setCopier(Copier copier) {
            this.myCopier = copier;
        }

        public void setCleaner(Cleaner cleaner) {
            this.myCleaner = cleaner;
        }

        public Decision[] getDecisions() {
            if (this.myMakersArray == null) {
                this.myMakersArray = this.myDecisions.toArray(new Decision[this.myDecisions.size()]);
            }
            return this.myMakersArray;
        }

        public void setMatcher(Matcher matcher) {
            this.myMatcher = matcher;
        }

        public Matcher getMatcher() {
            return this.myMatcher;
        }

        public Copier getCopier() {
            return this.myCopier;
        }

        public Cleaner getCleaner() {
            return this.myCleaner;
        }

        private void makersSetChanged() {
            this.myMakersArray = null;
        }
    }
}

