/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.figureview.view;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class FigureLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    protected Color papyrusColor = new Color((Device)Display.getDefault(), 0, 127, 14);
    protected Color customizableDropEditPolicyColor = new Color((Device)Display.getDefault(), 0, 38, 255);

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IFigure) {
            IFigure figure = (IFigure)element;
            switch (columnIndex) {
                case 0: {
                    String name = figure.getClass().getName();
                    int index = name.lastIndexOf(".");
                    if (index == -1) {
                        return name;
                    }
                    return name.substring(index + 1);
                }
                case 1: {
                    return figure.getBounds().toString();
                }
                case 2: {
                    if (figure.getLayoutManager() != null) {
                        return figure.getLayoutManager().getClass().getSimpleName();
                    }
                    return "none";
                }
                case 3: {
                    if (figure.getBorder() != null) {
                        String borderInfo = figure.getBorder().getClass().getSimpleName();
                        if (figure.getBorder() instanceof LineBorder) {
                            borderInfo = String.valueOf(borderInfo) + String.format(" (%d)", ((LineBorder)figure.getBorder()).getWidth());
                        }
                        return borderInfo;
                    }
                    return "no border";
                }
                case 4: {
                    if (figure instanceof Shape) {
                        return String.format("%d", ((Shape)figure).getLineWidth());
                    }
                    if (figure instanceof NodeFigure) {
                        return String.format("%d", ((NodeFigure)figure).getLineWidth());
                    }
                    return "not avail";
                }
            }
        }
        return "cannot display element: " + element;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

