/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.representation.architecture;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.utils.EditorNameInitializer;
import org.eclipse.papyrus.infra.textedit.representation.TextDocumentRepresentation;
import org.eclipse.papyrus.infra.textedit.representation.architecture.AbstractCreateTextDocumentEditorCommand;
import org.eclipse.papyrus.infra.textedit.representation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.infra.textedit.representation.command.ICreateTextDocumentEditorCommand;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocumentPackage;
import org.eclipse.papyrus.infra.textedit.ui.internal.viewpoint.TextDocumentViewPrototype;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class CreateTextDocumentEditorCommand
extends AbstractCreateTextDocumentEditorCommand
implements ICreateTextDocumentEditorCommand {
    private String askName(ViewPrototype prototype, EObject semanticContext) {
        String defaultName = this.getDefaultName(prototype, semanticContext);
        return this.askTextDocumentEditorName(Messages.CreateTextDocumentEditorCommand_PapyrusTextDocumentCreation, defaultName);
    }

    private String getDefaultName(ViewPrototype prototype, EObject semanticContext) {
        StringBuilder nameBuilder = new StringBuilder("New");
        nameBuilder.append(prototype.getLabel().replaceAll(" ", ""));
        String nameWithIncrement = EditorNameInitializer.getNameWithIncrement((EClass)TextDocumentPackage.eINSTANCE.getTextDocument(), (EStructuralFeature)TextDocumentPackage.eINSTANCE.getTextDocument_Name(), (String)nameBuilder.toString(), (EObject)semanticContext);
        return nameWithIncrement;
    }

    public TextDocument execute(ViewPrototype prototype, String name, EObject semanticContext, boolean openAfterCreation) {
        return this.execute(prototype, name, semanticContext, semanticContext, openAfterCreation);
    }

    public TextDocument execute(ViewPrototype prototype, String name, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation) {
        if (prototype instanceof TextDocumentViewPrototype) {
            String textDocumentName;
            PapyrusRepresentationKind representation = prototype.getRepresentationKind();
            Assert.isTrue((boolean)(representation instanceof TextDocumentRepresentation), (String)"The representation associated to the TextDocumentViewPrototype must be an instanceof TextDocumentRepresentation.");
            TextDocumentRepresentation textDocumentRepresentation = (TextDocumentRepresentation)representation;
            String string = textDocumentName = name == null || name.isEmpty() ? this.askName(prototype, semanticContext) : name;
            if (textDocumentName == null) {
                return null;
            }
            return super.execute(textDocumentRepresentation, textDocumentName, semanticContext, graphicalContext, openAfterCreation);
        }
        return null;
    }
}

