/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.palette.utils;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService;
import org.eclipse.papyrus.toolsmiths.palette.PaletteConstants;
import org.eclipse.ui.IEditorPart;

public class PaletteUtils {
    public static final Map<Object, Object> saveOptions;

    static {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("LINE_DELIMITER", "");
        options.put("URI_HANDLER", (String)new URIHandlerImpl.PlatformSchemeAware());
        saveOptions = Collections.unmodifiableMap(options);
    }

    public static PaletteConstants.PaletteModelContextEnum getPaletteModelContext(PapyrusPaletteService.ProviderDescriptor descriptor) {
        PaletteConstants.PaletteModelContextEnum paletteContext = descriptor instanceof PapyrusPaletteService.WorkspaceExtendedProviderDescriptor ? PaletteConstants.PaletteModelContextEnum.Workspace : (descriptor instanceof PapyrusPaletteService.ExtendedProviderDescriptor ? PaletteConstants.PaletteModelContextEnum.Plugin : (descriptor instanceof PapyrusPaletteService.LocalExtendedProviderDescriptor ? PaletteConstants.PaletteModelContextEnum.Local : PaletteConstants.PaletteModelContextEnum.New));
        return paletteContext;
    }

    public static boolean notErrorOnFile(File file) {
        boolean error = false;
        if (file != null) {
            if (!file.exists()) {
                error = true;
            } else if (!file.canRead()) {
                error = true;
            }
        }
        return !error;
    }

    public static String getEditorIdValue(IEditorPart editorPart) {
        String editorIDValue = "";
        if (editorPart instanceof DiagramEditorWithFlyOutPalette) {
            editorIDValue = ((DiagramEditorWithFlyOutPalette)editorPart).getContributorId();
        }
        return editorIDValue;
    }
}

