/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.property;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.property.IChangeIsStaticFromPropertyMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.ChangeIsStaticFeatureDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ChangeIsStaticFromPropertyMigrator
extends AbstractMigrator
implements IChangeIsStaticFromPropertyMigrator {
    private Property property;
    private Stereotype stereotype;
    private boolean isStatic;

    public ChangeIsStaticFromPropertyMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode treeNode) {
        if (TreeNodeUtils.isChangeType(treeNode, MigratorProfileApplication.appliedProfile)) {
            EObject element = TreeNodeUtils.getChangedElement(treeNode);
            EStructuralFeature structuralFeature = TreeNodeUtils.getChangedAttribute(treeNode);
            if (element instanceof Property && structuralFeature == UMLPackage.eINSTANCE.getFeature_IsStatic()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return ChangeIsStaticFromPropertyMigrator.isValid(this.treeNode);
    }

    @Override
    public void migrationAction() {
        List<StereotypeApplicationDescriptor> list;
        if (this.isDisplayDialogPreference() && this.isStatic && !(list = StereotypeApplicationRegistry.getAllStereotypeApplicationDescriptors(this.stereotype)).isEmpty()) {
            ChangeIsStaticFeatureDialog dialog = new ChangeIsStaticFeatureDialog(Display.getDefault().getActiveShell(), list.get(0).getStereotype(), this.property, list.get(0).getOwner());
            dialog.open();
            Object selectedValue = list.get(0).getOwner().getValue(list.get(0).getStereotype(), this.property.getName());
            int i = 1;
            while (i < list.size()) {
                list.get(i).getOwner().setValue(list.get(i).getStereotype(), this.property.getName(), selectedValue);
                ++i;
            }
        }
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            EObject element = TreeNodeUtils.getChangedElement(this.treeNode);
            this.property = (Property)element;
            this.stereotype = (Stereotype)this.property.getOwner();
            this.isStatic = this.property.isStatic();
        }
    }

    @Override
    public int getPriority() {
        return 47;
    }

    private boolean isDisplayDialogPreference() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getBoolean("ChangeIsStaticFeatureOfProperty");
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public boolean getValue() {
        return this.isStatic;
    }

    @Override
    public Element getChangedElement() {
        return this.getProperty();
    }

    @Override
    public Object getNewValue() {
        return this.getValue();
    }

    @Override
    public EStructuralFeature getChangedStructuralFeature() {
        return UMLPackage.eINSTANCE.getFeature_IsStatic();
    }
}

