/*
 * Decompiled with CFR 0.152.
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkConstraints;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.GenModelUtils_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private LinkUtils_qvto _linkUtils_qvto;
    @Inject
    @Extension
    private GenModelUtils_qvto _genModelUtils_qvto;

    public boolean hasChildrenOrCompartments(GenNode node) {
        return !node.getChildNodes().isEmpty() || !node.getCompartments().isEmpty();
    }

    public String getContainerVariable(TypeLinkModelFacet modelFacet) {
        String _xifexpression = null;
        GenFeature _sourceMetaFeature = modelFacet.getSourceMetaFeature();
        boolean _tripleNotEquals = _sourceMetaFeature != null;
        _xifexpression = _tripleNotEquals ? "container" : "source";
        return _xifexpression;
    }

    public Iterable<GenLinkConstraints> getValidLinkConstraints(GenDiagram diagram) {
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink l) {
                return l.getCreationConstraints() != null && l.getCreationConstraints().isValid();
            }
        };
        Iterable goodLinks = IterableExtensions.filter((Iterable)diagram.getLinks(), (Functions.Function1)_function);
        Functions.Function1<GenLink, GenLinkConstraints> _function_1 = new Functions.Function1<GenLink, GenLinkConstraints>(){

            public GenLinkConstraints apply(GenLink l) {
                return l.getCreationConstraints();
            }
        };
        return IterableExtensions.map((Iterable)goodLinks, (Functions.Function1)_function_1);
    }

    public Iterable<GenLink> getAllPotentialLinks(GenLinkEnd linkEnd) {
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                return Utils_qvto.this.isCreationAllowed(link);
            }
        };
        return IterableExtensions.filter(this.getAllRelatedLinks(linkEnd), (Functions.Function1)_function);
    }

    public Iterable<GenLink> getReroutableTypeLinks(GenLinkEnd linkEnd) {
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                return Utils_qvto.this._linkUtils_qvto.isTypeLink(link);
            }
        };
        return IterableExtensions.filter(this.getAllRelatedReroutableLinks(linkEnd), (Functions.Function1)_function);
    }

    public Iterable<GenLink> getReroutableRefLinks(GenLinkEnd linkEnd) {
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                return Utils_qvto.this._linkUtils_qvto.isRefLink(link);
            }
        };
        return IterableExtensions.filter(this.getAllRelatedReroutableLinks(linkEnd), (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAllRelatedLinks(final GenLinkEnd linkEnd) {
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                return Utils_qvto.this._linkUtils_qvto.canBeSource(link, linkEnd) || Utils_qvto.this._linkUtils_qvto.canBeTarget(link, linkEnd);
            }
        };
        return IterableExtensions.filter((Iterable)linkEnd.getDiagram().getLinks(), (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAllRelatedReroutableLinks(final GenLinkEnd linkEnd) {
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                return Utils_qvto.this._linkUtils_qvto.canBeSource(link, linkEnd) && link.isSourceReorientingAllowed() || Utils_qvto.this._linkUtils_qvto.canBeTarget(link, linkEnd) && link.isTargetReorientingAllowed();
            }
        };
        return IterableExtensions.filter((Iterable)linkEnd.getDiagram().getLinks(), (Functions.Function1)_function);
    }

    public boolean isCreationAllowed(GenLink link) {
        return link.getModelFacet() != null && (link.isOutgoingCreationAllowed() || link.isIncomingCreationAllowed());
    }

    public boolean createStartLinkCommand(GenLink link, GenLinkEnd linkEnd) {
        return this.createStartOutgoingLinkCommand(link, linkEnd) || this.createStartIncomingLinkCommand(link, linkEnd);
    }

    public boolean createStartOutgoingLinkCommand(GenLink link, GenLinkEnd linkEnd) {
        return this.isSelf(link, linkEnd) || this.isOutgoing(link, linkEnd) && link.isOutgoingCreationAllowed();
    }

    public boolean createStartIncomingLinkCommand(GenLink link, GenLinkEnd linkEnd) {
        return this.isIncoming(link, linkEnd) && link.isIncomingCreationAllowed();
    }

    public boolean createCompleteLinkCommand(GenLink link, GenLinkEnd linkEnd) {
        return this.createCompleteIncomingLinkCommand(link, linkEnd) || this.createCompleteOutgoingLinkCommand(link, linkEnd);
    }

    public boolean createCompleteIncomingLinkCommand(GenLink link, GenLinkEnd linkEnd) {
        return this.isSelf(link, linkEnd) || this.isIncoming(link, linkEnd) && link.isOutgoingCreationAllowed();
    }

    public boolean createCompleteOutgoingLinkCommand(GenLink link, GenLinkEnd linkEnd) {
        return this.isOutgoing(link, linkEnd) && link.isIncomingCreationAllowed();
    }

    public boolean checkSource(boolean reversedRequest, boolean isCompleteCommand) {
        return !reversedRequest || isCompleteCommand;
    }

    public boolean checkTarget(boolean reversedRequest, boolean isCompleteCommand) {
        return reversedRequest || isCompleteCommand;
    }

    private boolean isSelf(GenLink link, GenLinkEnd linkEnd) {
        return this._linkUtils_qvto.canBeSource(link, linkEnd) && this._linkUtils_qvto.canBeTarget(link, linkEnd);
    }

    private boolean isOutgoing(GenLink link, GenLinkEnd linkEnd) {
        return this._linkUtils_qvto.canBeSource(link, linkEnd) && !this._linkUtils_qvto.canBeTarget(link, linkEnd);
    }

    private boolean isIncoming(GenLink link, GenLinkEnd linkEnd) {
        return this._linkUtils_qvto.canBeTarget(link, linkEnd) && !this._linkUtils_qvto.canBeSource(link, linkEnd);
    }

    public boolean isDirectlyOwned(GenChildNode child, GenNode genNode) {
        boolean _tripleEquals;
        TypeModelFacet childFacet = child.getModelFacet();
        if (childFacet == null || genNode.getModelFacet() == null) {
            return false;
        }
        GenFeature _containmentMetaFeature = childFacet.getContainmentMetaFeature();
        boolean bl = _tripleEquals = _containmentMetaFeature == null;
        if (_tripleEquals) {
            return false;
        }
        return this._genModelUtils_qvto.isSuperTypeOf(childFacet.getContainmentMetaFeature().getGenClass(), genNode.getModelFacet().getMetaClass());
    }

    public Boolean containsCreateStartLinkCommand(GenLinkEnd it) {
        Iterable<GenLink> _allPotentialLinks = this.getAllPotentialLinks(it);
        for (GenLink l : _allPotentialLinks) {
            boolean _createStartLinkCommand = this.createStartLinkCommand(l, it);
            if (!_createStartLinkCommand) continue;
            return true;
        }
        return false;
    }

    public Boolean containsCreateCompleteLinkCommand(GenLinkEnd it) {
        Iterable<GenLink> _allPotentialLinks = this.getAllPotentialLinks(it);
        for (GenLink l : _allPotentialLinks) {
            boolean _createCompleteLinkCommand = this.createCompleteLinkCommand(l, it);
            if (!_createCompleteLinkCommand) continue;
            return true;
        }
        return false;
    }
}

