/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.Activator;
import org.eclipse.papyrus.customization.nattableconfiguration.messages.Messages;
import org.eclipse.papyrus.customization.nattableconfiguration.wizards.CreateAndEditTableConfigurationWizard;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class CreateNattableConfigurationProjectWizard
extends CreateAndEditTableConfigurationWizard
implements IWorkbenchWizard {
    private NewProjectCreationPage nattableConfigurationProjectCreationPage;
    private IProjectProvider projectProvider;
    protected PluginContentPage contentPage;
    private PluginFieldData pluginData;

    @Override
    public void addPages() {
        this.pluginData = new PluginFieldData();
        this.nattableConfigurationProjectCreationPage = new NewProjectCreationPage(Messages.NattableConfigurationProjectCreationPage_pageName, (AbstractFieldData)this.pluginData, false, (IStructuredSelection)new StructuredSelection());
        this.addPage((IWizardPage)this.nattableConfigurationProjectCreationPage);
        this.projectProvider = new IProjectProvider(){

            public String getProjectName() {
                return CreateNattableConfigurationProjectWizard.this.nattableConfigurationProjectCreationPage.getProjectName();
            }

            public IProject getProject() {
                return CreateNattableConfigurationProjectWizard.this.nattableConfigurationProjectCreationPage.getProjectHandle();
            }

            public IPath getLocationPath() {
                return CreateNattableConfigurationProjectWizard.this.nattableConfigurationProjectCreationPage.getLocationPath();
            }
        };
        this.contentPage = new PluginContentPage("page2", this.projectProvider, this.nattableConfigurationProjectCreationPage, (AbstractFieldData)this.pluginData);
        this.addPage((IWizardPage)this.contentPage);
        super.addPages();
    }

    @Override
    public boolean performFinish() {
        boolean result = false;
        IProject createdProject = null;
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new NewProjectCreationOperation((IFieldData)this.pluginData, this.projectProvider, null));
            createdProject = this.getProject();
            IWorkingSet[] workingSets = this.nattableConfigurationProjectCreationPage.getSelectedWorkingSets();
            if (workingSets.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)createdProject, workingSets);
            }
            this.copyAboutFile(createdProject);
            result = super.performFinish();
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
        if (result) {
            result = this.saveResource();
        }
        this.refreshProject();
        return result;
    }

    @Override
    protected String getPathForTableConfigurationCreation() {
        String projectLocation = this.getProjectLocation();
        StringBuilder builder = new StringBuilder(projectLocation);
        builder.append("/configs/");
        return builder.toString();
    }

    protected void copyAboutFile(IProject createdProject) {
        block21: {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                try {
                    URL url = Activator.getDefault().getBundle().getResource("about.html");
                    inputStream = url.openStream();
                    File newAboutFile = new File(String.valueOf(createdProject.getLocation().toOSString()) + File.separator + "about.html");
                    newAboutFile.createNewFile();
                    outputStream = new FileOutputStream(newAboutFile);
                    int read = 0;
                    byte[] bytes = new byte[1024];
                    while ((read = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, read);
                    }
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e2) {
                            Activator.log.error((Throwable)e2);
                        }
                    }
                    if (outputStream == null) break block21;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e3) {
                        Activator.log.error((Throwable)e3);
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected IProject getProject() {
        return this.projectProvider.getProject();
    }

    @Override
    protected String getProjectLocation() {
        IProject createdProject = this.getProject();
        return createdProject.getLocation().toString();
    }
}

