/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.commands;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.model.DecoratorModel;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateDecoratorModelCommand
extends AbstractCommand {
    private final TransactionalEditingDomain domain;
    private final URI resourceURI;
    private final String modelName;
    private Resource createdResource;
    private Package createdDecoratorModel;

    public CreateDecoratorModelCommand(TransactionalEditingDomain domain, URI resourceURI, String modelName) {
        super(Messages.CreateDecoratorModelCommand_0);
        this.domain = domain;
        this.resourceURI = resourceURI;
        this.modelName = modelName;
    }

    protected boolean prepare() {
        return this.domain != null && this.domain.getResourceSet() != null && this.resourceURI != null;
    }

    public void execute() {
        ResourceSet resourceSet = this.domain.getResourceSet();
        Resource decoratorModel = resourceSet.getResource(this.resourceURI, false);
        if (decoratorModel == null) {
            if (this.canLoad(resourceSet, this.resourceURI)) {
                resourceSet.getResource(this.resourceURI, true);
            } else {
                if (resourceSet instanceof ModelSet) {
                    DecoratorModel model = DecoratorModel.getInstance((ModelSet)resourceSet);
                    this.createdResource = model.loadDecoratorModel(this.resourceURI);
                } else {
                    this.createdResource = resourceSet.createResource(this.resourceURI, "org.eclipse.uml2.uml");
                }
                this.initializeDecoratorModel(this.createdResource, this.modelName);
            }
        }
    }

    protected void initializeDecoratorModel(Resource resource, String modelName) {
        this.createdDecoratorModel = UMLFactory.eINSTANCE.createPackage();
        this.createdDecoratorModel.setName(modelName);
        resource.getContents().add((Object)this.createdDecoratorModel);
        Profile externalizationProfile = DecoratorModelUtils.getExternalizationProfile(resource.getResourceSet());
        this.createdDecoratorModel.applyProfile(externalizationProfile);
    }

    protected boolean canLoad(ResourceSet resourceSet, URI resourceURI) {
        boolean result = resourceSet.getURIConverter().exists(resourceURI, null);
        if (result) {
            result = DecoratorModelUtils.isDecoratorModel(resourceURI);
        }
        return result;
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.createdResource != null) {
            this.createdResource.unload();
            this.createdResource.getResourceSet().getResources().remove((Object)this.createdResource);
            this.createdResource.eAdapters().clear();
        }
    }

    public void redo() {
        ResourceSet resourceSet;
        if (this.createdResource != null && (resourceSet = this.domain.getResourceSet()).getResource(this.createdResource.getURI(), false) == null) {
            resourceSet.getResources().add((Object)this.createdResource);
            this.createdResource.getContents().clear();
            this.createdResource.getContents().add((Object)this.createdDecoratorModel);
            ((InternalEObject)this.createdDecoratorModel).eSetProxyURI(null);
        }
    }
}

