/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.RoundedRectangleBorder;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.swt.graphics.Color;

public class PapyrusRoundedNodeFigure
extends NodeNamedElementFigure {
    public int corner = 15;

    public PapyrusRoundedNodeFigure() {
        this.shadowborder = new RoundedRectangleBorder(this.corner, this.corner);
        this.setBorder((Border)this.shadowborder);
    }

    @Override
    protected Border getDefaultBorder(Color borderColor) {
        return new RoundedRectangleBorder(this.corner, this.corner);
    }

    @Override
    public void paintFigure(Graphics graphics) {
        if (this.isOpaque() && this.getBorder() != null) {
            Rectangle tempRect = new Rectangle(this.getBounds());
            tempRect.crop(this.getBorder().getInsets((IFigure)this));
            graphics.fillRoundRectangle(tempRect, this.corner, this.corner);
            return;
        }
        if (this.isOpaque()) {
            graphics.fillRoundRectangle(this.getBounds(), this.corner, this.corner);
        }
        if (this.getBorder() instanceof AbstractBackground) {
            ((AbstractBackground)this.getBorder()).paintBackground((IFigure)this, graphics, NO_INSETS);
        }
        this.paintBackground(graphics, this.getBounds());
        this.shadowborder.setColor(this.getForegroundColor());
    }

    @Override
    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        if (this.isUsingGradient()) {
            boolean isVertical;
            this.applyTransparency(graphics);
            boolean bl = isVertical = this.getGradientStyle() == 0;
            if (isVertical && rectangle.height > 3 * this.corner / 2) {
                Rectangle rect1 = new Rectangle(rectangle.getLocation(), new Dimension(rectangle.width, this.corner));
                Rectangle rect2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - this.corner, rectangle.width, this.corner);
                graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
                graphics.fillRoundRectangle(rect1, this.corner, this.corner);
                graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
                graphics.fillRoundRectangle(rect2, this.corner, this.corner);
                graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
                graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
                Rectangle rect = new Rectangle(rectangle.x, rectangle.y + this.corner / 2, rectangle.width, rectangle.height - this.corner);
                graphics.fillGradient(rect, true);
            } else if (!isVertical && rectangle.width > 3 * this.corner / 2) {
                Rectangle rect1 = new Rectangle(rectangle.getLocation(), new Dimension(this.corner, rectangle.height));
                Rectangle rect2 = new Rectangle(rectangle.x + rectangle.width - this.corner, rectangle.y, this.corner, rectangle.height);
                graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
                graphics.fillRoundRectangle(rect1, this.corner, this.corner);
                graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
                graphics.fillRoundRectangle(rect2, this.corner, this.corner);
                graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
                graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
                Rectangle rect = new Rectangle(rectangle.x + this.corner / 2, rectangle.y, rectangle.width - this.corner, rectangle.height);
                graphics.fillGradient(rect, false);
            } else {
                graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
                graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
                graphics.fillRoundRectangle(rectangle, this.corner, this.corner);
            }
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.fillRoundRectangle(rectangle, this.corner, this.corner);
        }
    }
}

