/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import java.util.Iterator;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ShapeFlowLayout
extends FlowLayout {
    public ShapeFlowLayout() {
        super(true);
        this.setStretchMinorAxis(true);
        this.setMajorAlignment(0);
    }

    public void layout(IFigure parent) {
        this.data = new FlowLayout.WorkingData(this){};
        Rectangle relativeArea = parent.getClientArea();
        this.data.area = this.transposer.t(relativeArea);
        Iterator iterator = parent.getChildren().iterator();
        int totalPrefWidth = 0;
        int maxPrefHeight = 0;
        int wHint = -1;
        int hHint = -1;
        wHint = parent.getClientArea().width;
        hHint = parent.getClientArea().height;
        this.initVariables(parent);
        this.initRow();
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
            totalPrefWidth += pref.width;
            maxPrefHeight = Math.max(maxPrefHeight, pref.height);
        }
        double ratioWidth = 1.0;
        if (totalPrefWidth > 0) {
            ratioWidth = wHint / totalPrefWidth;
        }
        double ratioHeight = 1.0;
        if (maxPrefHeight > 0) {
            ratioHeight = hHint / maxPrefHeight;
        }
        double ratio = Math.min(ratioHeight, ratioWidth);
        for (IFigure f : parent.getChildren()) {
            Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
            Rectangle r = new Rectangle(0, 0, (int)((double)pref.width * ratio), (int)((double)pref.height * ratio));
            if (this.data.rowCount > 0 && this.data.rowWidth + pref.width > this.data.maxWidth) {
                this.layoutRow(parent);
            }
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.getMinorSpacing();
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = Math.max(this.data.rowHeight, r.height);
            this.data.row[this.data.rowCount] = f;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
        }
        if (this.data.rowCount != 0) {
            this.layoutRow(parent);
        }
        this.data = null;
    }

    protected void layoutRow(IFigure parent) {
        int majorAdjustment = 0;
        int minorAdjustment = 0;
        int correctMajorAlignment = this.getMajorAlignment();
        int correctMinorAlignment = this.getMinorAlignment();
        majorAdjustment = this.data.area.width - this.data.rowWidth + this.getMinorSpacing();
        switch (correctMajorAlignment) {
            case 1: {
                majorAdjustment = 0;
                break;
            }
            case 0: {
                majorAdjustment /= 2;
                break;
            }
        }
        int j = 0;
        while (j < this.data.rowCount) {
            if (this.isStretchMinorAxis()) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                minorAdjustment = this.data.rowHeight - this.data.bounds[j].height;
                switch (correctMinorAlignment) {
                    case 1: {
                        minorAdjustment = 0;
                        break;
                    }
                    case 0: {
                        minorAdjustment /= 2;
                        break;
                    }
                }
                this.data.bounds[j].y += minorAdjustment;
            }
            this.data.bounds[j].x += majorAdjustment;
            this.setBoundsOfChild(parent, this.data.row[j], this.transposer.t(this.data.bounds[j]));
            ++j;
        }
        this.data.rowY += this.getMajorSpacing() + this.data.rowHeight;
        this.initRow();
    }
}

