/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CenteredWrappedLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.ContinuationFigure;
import org.eclipse.swt.graphics.Image;

public class StateInvariantFigure
extends ContinuationFigure
implements ILabelFigure,
IMultilineEditableFigure,
IPapyrusNodeUMLElementFigure {
    protected static final String LEFT_BRACE = "{";
    protected static final String RIGHT_BRACE = "}";
    private int transparency = 0;
    private FlowPage constraintContentContainer;
    private TextFlowEx constraintContent;
    private CenteredWrappedLabel fFigureContinuationNameLabel;
    private PapyrusWrappingLabel stereotypesLabel;
    private Label stereotypePropertiesLabel;
    private IFigure labelContainer;
    private IMapMode mapMode;

    public StateInvariantFigure(IMapMode map) {
        this.getChildren().clear();
        this.mapMode = map;
        this.setBorder((Border)new MarginBorder(8));
        RoundedRectangle contents = new RoundedRectangle();
        contents.setCornerDimensions(new Dimension(this.mapMode.DPtoLP(50), this.mapMode.DPtoLP(50)));
        contents.setOutline(false);
        this.add((IFigure)contents);
        this.fFigureContinuationNameLabel = new CenteredWrappedLabel();
        contents.add((IFigure)this.fFigureContinuationNameLabel);
        this.constraintContentContainer = new FlowPage();
        this.constraintContentContainer.setOpaque(false);
        this.constraintContentContainer.setHorizontalAligment(2);
        this.constraintContent = new TextFlowEx("");
        this.constraintContentContainer.add((IFigure)this.constraintContent);
        contents.add((IFigure)this.constraintContentContainer);
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setStretchMinorAxis(true);
        layout.setMinorAlignment(0);
        contents.setLayoutManager((LayoutManager)layout);
        this.labelContainer = contents;
    }

    public FlowPage getConstraintContentContainer() {
        return this.constraintContentContainer;
    }

    @Override
    public CenteredWrappedLabel getFigureContinuationNameLabel() {
        return this.fFigureContinuationNameLabel;
    }

    @Override
    public IFigure getInvariantFigure() {
        return this;
    }

    protected void fillShape(Graphics graphics) {
        graphics.pushState();
        this.applyTransparency(graphics);
        graphics.fillRoundRectangle(this.getBounds(), this.corner.width, this.corner.height);
        graphics.popState();
    }

    public int getTransparency() {
        return this.transparency;
    }

    @Override
    public void setTransparency(int transparency) {
        if (transparency != this.transparency && transparency >= 0 && transparency <= 100) {
            this.transparency = transparency;
            this.repaint();
        }
    }

    protected void applyTransparency(Graphics g) {
        g.setAlpha(255 - this.transparency * 255 / 100);
    }

    public void setText(String text) {
        if (this.constraintContent != null) {
            this.constraintContent.setText(LEFT_BRACE + text + RIGHT_BRACE);
        }
    }

    public String getText() {
        if (this.constraintContent != null) {
            return this.constraintContent.getText();
        }
        return null;
    }

    public void setIcon(Image icon) {
    }

    public Image getIcon() {
        return null;
    }

    public Point getEditionLocation() {
        if (this.constraintContentContainer != null) {
            return this.constraintContentContainer.getLocation();
        }
        return null;
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
        if (stereotypes == null || stereotypes.trim().equals("")) {
            if (this.stereotypesLabel != null) {
                this.labelContainer.remove((IFigure)this.stereotypesLabel);
            }
            this.stereotypesLabel = null;
        } else if (this.stereotypesLabel == null) {
            this.stereotypesLabel = new PapyrusWrappingLabel(stereotypes, image);
            this.labelContainer.add((IFigure)this.stereotypesLabel, 0);
        } else {
            this.stereotypesLabel.setText(stereotypes);
            this.stereotypesLabel.setIcon(image);
        }
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
        if (stereotypeProperties == null || stereotypeProperties.trim().equals("")) {
            if (this.stereotypePropertiesLabel != null) {
                this.labelContainer.remove((IFigure)this.stereotypePropertiesLabel);
            }
            this.stereotypePropertiesLabel = null;
        } else {
            if (this.stereotypePropertiesLabel == null) {
                this.stereotypePropertiesLabel = new Label();
                int index = this.labelContainer.getChildren().indexOf(this.stereotypesLabel);
                this.labelContainer.add((IFigure)this.stereotypePropertiesLabel, index + 1);
            }
            this.stereotypePropertiesLabel.setText(LEFT_BRACE + stereotypeProperties + RIGHT_BRACE);
        }
    }

    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
    }

    public PapyrusWrappingLabel getStereotypesLabel() {
        return this.stereotypesLabel;
    }
}

