/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ShowViewRule
extends TestWatcher {
    private final String viewID;
    private IViewPart view;

    public ShowViewRule(String viewID) {
        this.viewID = viewID;
    }

    protected void starting(Description description) {
        IWorkbench bench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null) {
            window = bench.getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = window.getActivePage();
        this.view = page.findView(this.viewID);
        if (this.view == null) {
            try {
                this.view = page.showView(this.viewID);
            }
            catch (PartInitException e) {
                Assert.fail((String)String.format("Failed to show view %s: %s", this.viewID, e.getLocalizedMessage()));
            }
        }
    }

    protected void finished(Description description) {
        if (this.view != null) {
            this.view.getSite().getPage().hideView(this.view);
        }
        this.view = null;
    }
}

