/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelexplorer.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.papyrus.uml.modelexplorer.Activator;
import org.eclipse.papyrus.uml.modelexplorer.messages.Messages;
import org.eclipse.papyrus.uml.tools.profile.definition.LabelStylersEnum;
import org.eclipse.papyrus.uml.tools.profile.definition.LabelTypesEnum;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class CustomizeUMLLabelDialog
extends SelectionDialog
implements SelectionListener {
    private static final String CUSTO_NAME_STEREOTYPE = "Name and Stereotype";
    private static final String CUSTO_STEREOTYPE_METACLASS_NAME = "Stereotype, Metaclass and Name";
    protected static final String CUSTO_NAME = "Name";
    protected static final String CUSTO_CUSTOM = "Customized";
    protected TableViewer tableViewer;
    protected Button add;
    protected Button remove;
    protected Button up;
    protected Button down;
    protected Composite controlsSection;
    protected List<String> predefinedCustoList = new ArrayList<String>(){
        {
            this.add(CustomizeUMLLabelDialog.CUSTO_CUSTOM);
            this.add(CustomizeUMLLabelDialog.CUSTO_NAME);
            this.add(CustomizeUMLLabelDialog.CUSTO_STEREOTYPE_METACLASS_NAME);
            this.add(CustomizeUMLLabelDialog.CUSTO_NAME_STEREOTYPE);
        }
    };
    protected ComboViewer predefinedCustoViewer;

    public CustomizeUMLLabelDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(Messages.CustomizeUMLLabelDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setText(Messages.CustomizeUMLLabelDialog_dialogLabel);
        this.createStylesTablePart(composite);
        this.createListControls();
        this.createLoadPredefinedCustoPart(composite);
        this.updateControls();
        return composite;
    }

    protected void createStylesTablePart(Composite composite) {
        this.controlsSection = new Composite(composite, 0);
        this.controlsSection.setLayout((Layout)new FillLayout());
        this.controlsSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.tableViewer = new TableViewer(composite, 68354);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns(this.tableViewer);
        this.tableViewer.setInput(this.getEntriesFromPreferences());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 150;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizeUMLLabelDialog.this.updateControls();
            }
        });
    }

    protected void createLoadPredefinedCustoPart(Composite composite) {
        Composite predifineComposite = new Composite(composite, 0);
        predifineComposite.setLayout((Layout)new FillLayout());
        predifineComposite.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        Label labelSelectStyle = new Label(predifineComposite, 0);
        labelSelectStyle.setText(Messages.CustomizeUMLLabelDialog_ComboCustomizationLabel);
        this.predefinedCustoViewer = new ComboViewer(predifineComposite, 0);
        this.predefinedCustoViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.predefinedCustoViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.predefinedCustoViewer.setInput(this.predefinedCustoList);
        this.predefinedCustoViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizeUMLLabelDialog.this.updateTable(event);
            }
        });
        this.predefinedCustoViewer.setSelection((ISelection)new StructuredSelection((Object)CUSTO_CUSTOM), true);
    }

    /*
     * Exception decompiling
     */
    protected void updateTable(SelectionChangedEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl74 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl74 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void createListControls() {
        this.up = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Up_12x12.gif"), Messages.CustomizeUMLLabelDialog_upButtonTooltip);
        this.down = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Down_12x12.gif"), Messages.CustomizeUMLLabelDialog_downButtonTooltip);
        this.add = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Add_12x12.gif"), Messages.CustomizeUMLLabelDialog_createButtonTooltip);
        this.remove = this.createButton(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Delete_12x12.gif"), Messages.CustomizeUMLLabelDialog_deleteButtonTooltip);
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.controlsSection, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        return button;
    }

    protected List<String[]> getEntriesFromPreferences() {
        String[] types = Activator.getDefault().getPreferenceStore().getString("CustomizedTypes").split(" ");
        String[] styles = Activator.getDefault().getPreferenceStore().getString("CustomizedStyles").split(" ");
        ArrayList<String[]> entries = new ArrayList<String[]>();
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            String style = i < styles.length ? styles[i] : LabelStylersEnum.BLACK.getLiteral();
            String[] entry = new String[]{type, style};
            entries.add(entry);
            ++i;
        }
        return entries;
    }

    protected void createColumns(TableViewer viewer) {
        TableViewerColumn colTypes = new TableViewerColumn(viewer, 0);
        colTypes.getColumn().setWidth(200);
        colTypes.getColumn().setText(Messages.CustomizeUMLLabelDialog_typesColumnTitle);
        colTypes.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String text;
                if (element instanceof String[]) {
                    String[] entry = (String[])element;
                    text = entry[0];
                } else {
                    text = element.toString();
                }
                return text;
            }
        });
        colTypes.setEditingSupport((EditingSupport)new ArrayStringWithComboEditingSupport((ColumnViewer)this.tableViewer, 0, LabelTypesEnum.values()));
        TableViewerColumn colStyles = new TableViewerColumn(viewer, 0);
        colStyles.getColumn().setWidth(200);
        colStyles.getColumn().setText(Messages.CustomizeUMLLabelDialog_stylesColumnTitle);
        colStyles.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String text;
                if (element instanceof String[]) {
                    String[] entry = (String[])element;
                    text = entry[1];
                } else {
                    text = element.toString();
                }
                return text;
            }
        });
        colStyles.setEditingSupport((EditingSupport)new ArrayStringWithComboEditingSupport((ColumnViewer)this.tableViewer, 1, LabelStylersEnum.values()));
    }

    protected void okPressed() {
        Map<String, String> map = this.getLabelStylesMap();
        this.setResult(Collections.singletonList(map));
        super.okPressed();
    }

    protected Map<String, String> getLabelStylesMap() {
        StringBuilder types = new StringBuilder();
        StringBuilder styles = new StringBuilder();
        if (this.tableViewer.getInput() instanceof List) {
            List entries = (List)this.tableViewer.getInput();
            int i = 0;
            while (i < entries.size()) {
                String[] entry = (String[])entries.get(i);
                types.append(entry[0]);
                styles.append(entry[1]);
                if (i < entries.size() - 1) {
                    types.append(" ");
                    styles.append(" ");
                }
                ++i;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CustomizedTypes", types.toString());
        map.put("CustomizedStyles", styles.toString());
        return map;
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget != null) {
            if (event.widget == this.add) {
                this.addAction();
            } else if (event.widget == this.remove) {
                this.removeAction();
            } else if (event.widget == this.up) {
                this.upAction();
            } else if (event.widget == this.down) {
                this.downAction();
            }
            this.updateControls();
            this.tableViewer.refresh();
            this.predefinedCustoViewer.setSelection((ISelection)new StructuredSelection((Object)CUSTO_CUSTOM), true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected Object getSelection() {
        return this.tableViewer.getStructuredSelection().getFirstElement();
    }

    protected void updateControls() {
        Object selection = this.getSelection();
        this.remove.setEnabled(selection != null);
        this.down.setEnabled(selection != null && !this.isSelectionLast());
        this.up.setEnabled(selection != null && !this.isSelectionFirst());
    }

    protected void downAction() {
        Object input;
        Object selection = this.getSelection();
        if (selection != null && !this.isSelectionLast() && (input = this.tableViewer.getInput()) instanceof List) {
            int index = ((List)input).indexOf(selection);
            ((List)input).remove(selection);
            ((List)input).add(index + 1, selection);
        }
    }

    protected void upAction() {
        Object input;
        Object selection = this.getSelection();
        if (selection != null && !this.isSelectionFirst() && (input = this.tableViewer.getInput()) instanceof List) {
            int index = ((List)input).indexOf(selection);
            ((List)input).remove(selection);
            ((List)input).add(index - 1, selection);
        }
    }

    protected void removeAction() {
        List selections = this.tableViewer.getStructuredSelection().toList();
        for (Object selection : selections) {
            Object input = this.tableViewer.getInput();
            if (!(input instanceof List)) continue;
            ((List)input).remove(selection);
        }
    }

    protected void addAction() {
        Object input = this.tableViewer.getInput();
        if (input instanceof List) {
            Object[] newEntry = new String[]{LabelTypesEnum.LABEL.getLiteral(), LabelStylersEnum.BLACK.getLiteral()};
            ((List)input).add(newEntry);
            this.tableViewer.refresh();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(newEntry));
            this.tableViewer.refresh();
        }
    }

    protected boolean isSelectionLast() {
        boolean isLast = false;
        Object selection = this.getSelection();
        Object input = this.tableViewer.getInput();
        if (input instanceof List) {
            isLast = ((List)input).indexOf(selection) == ((List)input).size() - 1;
        }
        return isLast;
    }

    protected boolean isSelectionFirst() {
        boolean isLast = false;
        Object selection = this.getSelection();
        Object input = this.tableViewer.getInput();
        if (input instanceof List) {
            isLast = ((List)input).indexOf(selection) == 0;
        }
        return isLast;
    }

    private class ArrayStringWithComboEditingSupport
    extends EditingSupport {
        private int index;
        private Object comboInput;

        public ArrayStringWithComboEditingSupport(ColumnViewer viewer, int index, Object comboInput) {
            super(viewer);
            this.index = index;
            this.comboInput = comboInput;
        }

        protected CellEditor getCellEditor(Object element) {
            ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)CustomizeUMLLabelDialog.this.tableViewer.getTable());
            cellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            cellEditor.setInput(this.comboInput);
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            boolean canEdit = false;
            if (element instanceof String[] && this.index < ((String[])element).length) {
                canEdit = true;
            }
            return canEdit;
        }

        protected Object getValue(Object element) {
            String text;
            if (element instanceof String[] && this.index < ((String[])element).length) {
                String[] entry = (String[])element;
                text = entry[this.index];
            } else {
                text = element.toString();
            }
            return text;
        }

        protected void setValue(Object element, Object value) {
            if (value != null && element instanceof String[] && this.index < ((String[])element).length) {
                String[] entry = (String[])element;
                entry[this.index] = value.toString();
                CustomizeUMLLabelDialog.this.tableViewer.update(element, null);
            }
        }
    }
}

