/**
 * Copyright (c) 2006, 2009, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 explicit call to the parent page on clean up
 */
package impl.preferences;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StandardPreferencePages;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class StandardPage {
  @Inject
  @Extension
  private Common _common;
  
  public CharSequence className(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence packageName(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    String _preferencesPackageName = it.getDiagram().getPreferencesPackageName();
    _builder.append(_preferencesPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("setPreferenceStore(");
    String _activatorQualifiedClassName = it.getDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName();
    _builder.append(_activatorQualifiedClassName, "\t\t");
    _builder.append(".getInstance().getPreferenceStore());");
    _builder.newLineIfNotEmpty();
    {
      StandardPreferencePages _kind = it.getKind();
      boolean _equals = Objects.equal(StandardPreferencePages.GENERAL_LITERAL, _kind);
      if (_equals) {
        _builder.append("\t\t");
        _builder.append("setPreferenceKey(");
        String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
        _builder.append(_editPartsPackageName, "\t\t");
        _builder.append(".");
        String _editPartClassName = it.getDiagram().getEditPartClassName();
        _builder.append(_editPartClassName, "\t\t");
        _builder.append(".MODEL_ID);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenStandardPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      StandardPreferencePages _kind = it.getKind();
      boolean _equals = Objects.equal(_kind, StandardPreferencePages.GENERAL_LITERAL);
      if (_equals) {
        _builder.append("extends org.eclipse.papyrus.infra.gmfdiag.preferences.pages.DiagramPreferencePage");
        _builder.newLine();
      } else {
        StandardPreferencePages _kind_1 = it.getKind();
        boolean _equals_1 = Objects.equal(_kind_1, StandardPreferencePages.APPEARANCE_LITERAL);
        if (_equals_1) {
          _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.AppearancePreferencePage");
          _builder.newLine();
        } else {
          StandardPreferencePages _kind_2 = it.getKind();
          boolean _equals_2 = Objects.equal(_kind_2, StandardPreferencePages.CONNECTIONS_LITERAL);
          if (_equals_2) {
            _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.ConnectionsPreferencePage");
            _builder.newLine();
          } else {
            StandardPreferencePages _kind_3 = it.getKind();
            boolean _equals_3 = Objects.equal(_kind_3, StandardPreferencePages.PRINTING_LITERAL);
            if (_equals_3) {
              _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.PrintingPreferencePage");
              _builder.newLine();
            } else {
              StandardPreferencePages _kind_4 = it.getKind();
              boolean _equals_4 = Objects.equal(_kind_4, StandardPreferencePages.RULERS_AND_GRID_LITERAL);
              if (_equals_4) {
                _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.preferences.RulerGridPreferencePage");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  /**
   * Bug 569174 : L1.2 clean up will generate an explicit call to the parent page on call_initDefaults
   */
  public String getParentPage(final GenStandardPreferencePage it) {
    String _xifexpression = null;
    StandardPreferencePages _kind = it.getKind();
    boolean _equals = Objects.equal(_kind, StandardPreferencePages.GENERAL_LITERAL);
    if (_equals) {
      _xifexpression = "org.eclipse.gmf.runtime.diagram.ui.preferences.DiagramsPreferencePage";
    } else {
      String _xifexpression_1 = null;
      StandardPreferencePages _kind_1 = it.getKind();
      boolean _equals_1 = Objects.equal(_kind_1, StandardPreferencePages.APPEARANCE_LITERAL);
      if (_equals_1) {
        _xifexpression_1 = "org.eclipse.gmf.runtime.diagram.ui.preferences.AppearancePreferencePage";
      } else {
        String _xifexpression_2 = null;
        StandardPreferencePages _kind_2 = it.getKind();
        boolean _equals_2 = Objects.equal(_kind_2, StandardPreferencePages.CONNECTIONS_LITERAL);
        if (_equals_2) {
          _xifexpression_2 = "org.eclipse.gmf.runtime.diagram.ui.preferences.ConnectionsPreferencePage";
        } else {
          String _xifexpression_3 = null;
          StandardPreferencePages _kind_3 = it.getKind();
          boolean _equals_3 = Objects.equal(_kind_3, StandardPreferencePages.PRINTING_LITERAL);
          if (_equals_3) {
            _xifexpression_3 = "org.eclipse.gmf.runtime.diagram.ui.preferences.PrintingPreferencePage";
          } else {
            String _xifexpression_4 = null;
            StandardPreferencePages _kind_4 = it.getKind();
            boolean _equals_4 = Objects.equal(_kind_4, StandardPreferencePages.RULERS_AND_GRID_LITERAL);
            if (_equals_4) {
              _xifexpression_4 = "org.eclipse.gmf.runtime.diagram.ui.preferences.RulerGridPreferencePage";
            }
            _xifexpression_3 = _xifexpression_4;
          }
          _xifexpression_2 = _xifexpression_3;
        }
        _xifexpression_1 = _xifexpression_2;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  @MetaDef
  public CharSequence call_initDefaults(final GenStandardPreferencePage it, final String storeVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      StandardPreferencePages _kind = it.getKind();
      boolean _notEquals = (!Objects.equal(_kind, StandardPreferencePages.PATHMAPS_LITERAL));
      if (_notEquals) {
        String _parentPage = this.getParentPage(it);
        _builder.append(_parentPage);
        _builder.append(".initDefaults(");
        _builder.append(storeVarName);
        _builder.append(");");
      }
    }
    return _builder;
  }
}
