/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.application;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Externalizer;

@Singleton
@SuppressWarnings("all")
public class WorkbenchWindowAdvisor {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private ActionBarAdvisor xptActionBarAdvisor;
  
  public CharSequence className(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _workbenchWindowAdvisorClassName = it.getWorkbenchWindowAdvisorClassName();
    _builder.append(_workbenchWindowAdvisorClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence WorkbenchWindowAdvisor(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.ui.application.WorkbenchWindowAdvisor {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("(org.eclipse.ui.application.IWorkbenchWindowConfigurer configurer) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(configurer);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createActionBarAdvisor = this.createActionBarAdvisor(it);
    _builder.append(_createActionBarAdvisor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _preWindowOpen = this.preWindowOpen(it);
    _builder.append(_preWindowOpen, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createActionBarAdvisor(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.ui.application.ActionBarAdvisor createActionBarAdvisor(org.eclipse.ui.application.IActionBarConfigurer configurer) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new ");
    CharSequence _qualifiedClassName = this.xptActionBarAdvisor.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append("(configurer);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence preWindowOpen(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void preWindowOpen() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.application.IWorkbenchWindowConfigurer configurer = getWindowConfigurer();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("configurer.setInitialSize(new org.eclipse.swt.graphics.Point(1000, 700));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("configurer.setTitle(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForWindowTitle(it));
    _builder.append(_accessorCall, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nAccessors(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForWindowTitle(it));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nValues(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForWindowTitle(it), it.getTitle());
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  protected String i18nKeyForWindowTitle(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".Title");
  }
}
