/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.AbstractPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.pde.internal.core.builders.DefaultSAXParser;
import org.eclipse.pde.internal.core.builders.XMLErrorReporter;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionsChecker<T extends EObject, P extends DefaultHandler>
extends AbstractPluginChecker {
    private final IProject project;
    private final IFile modelFile;
    private final Collection<? extends T> existingModels;
    private final PluginErrorReporterFactory<? super T, ? extends P> reporterFactory;

    public ExtensionsChecker(IProject project, IFile modelFile, Collection<? extends T> existingModels, PluginErrorReporterFactory<? super T, ? extends P> reporterFactory) {
        this(project, modelFile, existingModels, "org.eclipse.pde.core.problem", reporterFactory);
    }

    public ExtensionsChecker(IProject project, IFile modelFile, Collection<? extends T> existingModels, String markerType, PluginErrorReporterFactory<? super T, ? extends P> reporterFactory) {
        super(project, modelFile, markerType);
        this.project = project;
        this.modelFile = modelFile;
        this.existingModels = existingModels;
        this.reporterFactory = reporterFactory;
    }

    @Override
    public void check(DiagnosticChain diagnostics, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ExtensionsChecker_0, (Object)this.modelFile), (int)this.existingModels.size());
        IFile pluginXML = ProjectManagementService.getPluginXMLFile((IContainer)this.project);
        if (pluginXML == null) {
            MarkersService.createMarker((IResource)this.modelFile, "org.eclipse.pde.core.problem", NLS.bind((String)Messages.ExtensionsChecker_1, (Object)this.modelFile.getName()), 2);
            return;
        }
        for (EObject model : this.existingModels) {
            P reporter = this.reporterFactory.createErrorReporter(pluginXML, this.modelFile, model);
            DefaultSAXParser.parse((IFile)pluginXML, (XMLErrorReporter)((XMLErrorReporter)reporter));
            ((IPluginChecker2)reporter).check(diagnostics, monitor);
            subMonitor.worked(1);
        }
        SubMonitor.done((IProgressMonitor)monitor);
    }

    @FunctionalInterface
    public static interface PluginErrorReporterFactory<T extends EObject, P extends DefaultHandler> {
        public P createErrorReporter(IFile var1, IFile var2, T var3);
    }
}

