/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.wizards.pages.simple;

import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.gmf.gmfgraph.Canvas;
import org.eclipse.papyrus.gmf.gmfgraph.ChildAccess;
import org.eclipse.papyrus.gmf.gmfgraph.Connection;
import org.eclipse.papyrus.gmf.gmfgraph.DecorationFigure;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramElement;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramLabel;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.papyrus.gmf.gmfgraph.FigureGallery;
import org.eclipse.papyrus.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.papyrus.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.papyrus.gmf.gmfgraph.Identity;
import org.eclipse.papyrus.gmf.gmfgraph.Label;
import org.eclipse.papyrus.gmf.gmfgraph.Layout;
import org.eclipse.papyrus.gmf.gmfgraph.Node;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineConnection;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineDecoration;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.papyrus.gmf.gmfgraph.Rectangle;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.pages.simple.Messages;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.pages.simple.ResolvedItem;
import org.eclipse.papyrus.gmf.internal.common.IncrementalNamesDispenser;
import org.eclipse.papyrus.gmf.internal.common.NamesDispenser;

public class GraphDefBuilder {
    protected final Canvas existingCanvas;
    protected final GMFGraphFactory gmfGraphFactory = GMFGraphPackage.eINSTANCE.getGMFGraphFactory();
    protected final NamesDispenser namesDispenser = new IncrementalNamesDispenser();
    protected Canvas canvas;
    protected FigureGallery fGallery;

    public GraphDefBuilder(Canvas existingCanvas) {
        this.existingCanvas = existingCanvas;
    }

    public static DiagramElement getDiagramElement(Iterator<EObject> source, EObject domainElement) {
        String name = WizardUtil.getCapName(domainElement);
        if (name == null) {
            return null;
        }
        return GraphDefBuilder.getDiagramElement(source, name);
    }

    public static DiagramElement getDiagramElement(Iterator<EObject> source, String domainObjectName) {
        while (source.hasNext()) {
            EObject next = source.next();
            if (!(next instanceof DiagramElement) || !domainObjectName.equals(((DiagramElement)next).getName())) continue;
            return (DiagramElement)next;
        }
        return null;
    }

    protected String getUniqueName(String semanticPart) {
        return this.namesDispenser.get(semanticPart);
    }

    protected String getUniqueName(String semanticPart, String suffixPart) {
        return this.namesDispenser.get(semanticPart, suffixPart);
    }

    protected void addExistingName(String name) {
        if (name != null) {
            this.namesDispenser.add(name);
        }
    }

    protected void addExistingNames(Canvas canvas) {
        TreeIterator it = canvas.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof Identity)) continue;
            this.addExistingName(((Identity)next).getName());
        }
    }

    public Canvas process(ResolvedItem item) {
        if (this.existingCanvas == null) {
            this.canvas = this.gmfGraphFactory.createCanvas();
        } else {
            this.canvas = this.existingCanvas;
            this.addExistingNames(this.existingCanvas);
        }
        if (item != null) {
            if (this.canvas != this.existingCanvas) {
                EPackage ePackage = (EPackage)item.getDomainRef();
                this.canvas.setName(this.getUniqueName(ePackage.getName()));
            }
            this.fGallery = null;
            for (Object figure : this.canvas.getFigures()) {
                if (!(figure instanceof FigureGallery)) continue;
                this.fGallery = (FigureGallery)figure;
            }
            if (this.fGallery == null) {
                this.fGallery = this.gmfGraphFactory.createFigureGallery();
                this.fGallery.setName(this.getUniqueName(Messages.GraphDefBuilder0));
                this.canvas.getFigures().add((Object)this.fGallery);
            }
            for (ResolvedItem child : item.getChildren()) {
                this.process(child, null);
            }
        }
        return this.canvas;
    }

    protected void process(ResolvedItem item, DiagramElement parent) {
        EClass containingClass;
        DiagramElement newParent = GraphDefBuilder.getDiagramElement((Iterator<EObject>)this.canvas.eAllContents(), (EObject)item.getDomainRef());
        if (item.isDisabled()) {
            assert (newParent != null) : "For disabled item there should be a diagram element with the appropriate name";
        } else if (item.getDomainRef() instanceof EClass) {
            EClass type = (EClass)item.getDomainRef();
            if (item.getResolution() == ResolvedItem.Resolution.NODE) {
                newParent = this.createNode(type);
            } else if (item.getResolution() == ResolvedItem.Resolution.LINK) {
                newParent = this.createLink(type);
            }
        } else if (item.getDomainRef() instanceof EReference) {
            EReference ref = (EReference)item.getDomainRef();
            if (item.getResolution() == ResolvedItem.Resolution.LINK) {
                containingClass = (EClass)item.getParent().getDomainRef();
                newParent = this.createLink(ref, containingClass);
            }
        } else if (item.getDomainRef() instanceof EAttribute) {
            EAttribute attr = (EAttribute)item.getDomainRef();
            if (item.getResolution() == ResolvedItem.Resolution.LABEL) {
                containingClass = (EClass)item.getParent().getDomainRef();
                newParent = this.createLabel(attr, containingClass, parent);
            }
        }
        for (ResolvedItem next : item.getChildren()) {
            this.process(next, newParent);
        }
    }

    protected Node createNode(EClass type) {
        String baseName = WizardUtil.getCapName(type);
        Rectangle figure = this.gmfGraphFactory.createRectangle();
        figure.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder1));
        Node node = this.gmfGraphFactory.createNode();
        node.setFigure(GraphDefBuilder.newDescriptor(figure.getName(), (RealFigure)figure));
        this.fGallery.getDescriptors().add((Object)node.getFigure());
        node.setName(this.getUniqueName(baseName, null));
        this.canvas.getNodes().add((Object)node);
        return node;
    }

    protected Connection createLink(EClass type) {
        String baseName = WizardUtil.getCapName(type);
        PolylineConnection figure = this.gmfGraphFactory.createPolylineConnection();
        figure.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder1));
        Connection link = this.gmfGraphFactory.createConnection();
        link.setFigure(GraphDefBuilder.newDescriptor(figure.getName(), (RealFigure)figure));
        this.fGallery.getDescriptors().add((Object)link.getFigure());
        link.setName(this.getUniqueName(baseName, null));
        this.canvas.getConnections().add((Object)link);
        return link;
    }

    protected Connection createLink(EReference ref, EClass containingClass) {
        String baseName = WizardUtil.getCapName((EStructuralFeature)ref, containingClass);
        PolylineConnection figure = this.gmfGraphFactory.createPolylineConnection();
        figure.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder1));
        PolylineDecoration decoration = this.gmfGraphFactory.createPolylineDecoration();
        decoration.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder6));
        figure.setTargetDecoration((DecorationFigure)decoration);
        this.fGallery.getFigures().add((Object)decoration);
        Connection link = this.gmfGraphFactory.createConnection();
        link.setFigure(GraphDefBuilder.newDescriptor(figure.getName(), (RealFigure)figure));
        this.fGallery.getDescriptors().add((Object)link.getFigure());
        link.setName(this.getUniqueName(baseName, null));
        this.canvas.getConnections().add((Object)link);
        return link;
    }

    protected DiagramLabel createLabel(EAttribute attr, EClass containingClass, DiagramElement parent) {
        if (parent == null) {
            return null;
        }
        String baseName = WizardUtil.getCapName((EStructuralFeature)attr, containingClass);
        Label figure = this.gmfGraphFactory.createLabel();
        figure.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder1));
        figure.setText(Messages.GraphDefBuilder5);
        assert (parent.getFigure().getActualFigure() instanceof RealFigure) : "We are creators of this gmfgraph; there should be nothing but figure";
        RealFigure realFigure = (RealFigure)parent.getFigure().getActualFigure();
        if (parent instanceof Node && realFigure.getLayout() == null) {
            realFigure.setLayout((Layout)GMFGraphFactory.eINSTANCE.createFlowLayout());
        }
        realFigure.getChildren().add((Object)figure);
        DiagramLabel label = this.gmfGraphFactory.createDiagramLabel();
        label.setFigure(parent.getFigure());
        label.setAccessor(GraphDefBuilder.newAccess(parent.getFigure(), (RealFigure)figure));
        label.setName(this.getUniqueName(baseName, null));
        this.canvas.getLabels().add((Object)label);
        return label;
    }

    private static FigureDescriptor newDescriptor(String name, RealFigure fig) {
        FigureDescriptor fd = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
        fd.setActualFigure((Figure)fig);
        fd.setName(name);
        return fd;
    }

    private static ChildAccess newAccess(FigureDescriptor fd, RealFigure child) {
        ChildAccess ca = GMFGraphFactory.eINSTANCE.createChildAccess();
        ca.setFigure((Figure)child);
        fd.getAccessors().add((Object)ca);
        return ca;
    }
}

