/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.genmodel;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.InternalTransformationExecutor;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.RuntimeGenModelAccess;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.VisualIdentifierDispenserFacade;
import org.eclipse.papyrus.gmf.mappings.Mapping;

public class QVTDiagramGenModelTransformer {
    private static final String myTransfPath = "platform:/plugin/org.eclipse.papyrus.gmf.bridge/transforms/Map2Gen.qvto";
    private URI myTransfURI;
    private Trace myTrace;
    private final ResourceSet myResourceSet;
    private EPackage.Registry myRegistry;

    public QVTDiagramGenModelTransformer(ResourceSet resourceSet, VisualIdentifierDispenser idDespenser) {
        this.myResourceSet = resourceSet;
        VisualIdentifierDispenserFacade.Provider.setDispenser(idDespenser);
    }

    public static URL getDefaultTransformation() {
        try {
            return new URL(myTransfPath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ExecutionDiagnostic transform(Mapping m, GenModel genModel, ModelExtent output, ExecutionContext context) {
        final Resource trace = m.eResource() == null ? this.myResourceSet.createResource(URI.createURI((String)"trace.qvtotrace")) : this.myResourceSet.createResource(m.eResource().getURI().trimFileExtension().appendFileExtension("qvtotrace"));
        InternalTransformationExecutor executor = new InternalTransformationExecutor(this.getTransformation()){

            protected void handleExecutionTraces(Trace traces) {
                super.handleExecutionTraces(traces);
                trace.getContents().add((Object)traces);
            }
        };
        RuntimeGenModelAccess runtimeAccess = new RuntimeGenModelAccess();
        runtimeAccess.ensure();
        ExecutionDiagnostic result = executor.execute(context, new ModelExtent[]{this.getModelExtent((EObject)m), this.getModelExtent((EObject)genModel), this.getModelExtent((EObject)runtimeAccess.genPackage().getGenModel()), output});
        this.myTrace = trace.getContents().isEmpty() ? null : (Trace)trace.getContents().get(0);
        return result;
    }

    public void setRegistry(EPackage.Registry registry) {
        this.myRegistry = registry;
    }

    public ExecutionDiagnostic transform(Mapping m, GenModel genModel, ModelExtent output, ExecutionContext context, URI ... extensions) {
        ExecutionDiagnostic result = this.transform(m, genModel, output, context);
        if (result.getSeverity() != 0) {
            return result;
        }
        GenEditorGenerator outputGenModel = null;
        if (output.getContents().size() == 1 && output.getContents().get(0) instanceof GenEditorGenerator) {
            outputGenModel = (GenEditorGenerator)output.getContents().get(0);
        }
        if (outputGenModel == null) {
            return result;
        }
        output = this.getModelExtent((EObject)outputGenModel);
        URI[] uRIArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            URI extension = uRIArray[n2];
            InternalTransformationExecutor exec = this.myRegistry == null ? new InternalTransformationExecutor(extension) : new InternalTransformationExecutor(extension, this.myRegistry);
            exec.loadTransformation((IProgressMonitor)new NullProgressMonitor());
            result = 1 == exec.getTransformation().getModelParameter().size() ? exec.execute(context, new ModelExtent[]{output}) : exec.execute(context, new ModelExtent[]{this.getModelExtent((EObject)m), this.getModelExtent((EObject)this.myTrace), output});
            ++n2;
        }
        return result;
    }

    public Trace getTrace() {
        return this.myTrace;
    }

    private BasicModelExtent getModelExtent(EObject rootObject) {
        BasicEList mapObjects = new BasicEList();
        mapObjects.add((Object)rootObject);
        return new BasicModelExtent((List)mapObjects);
    }

    public void setTransformationL(URL mainTransformation) {
        this.myTransfURI = URI.createURI((String)mainTransformation.toString());
    }

    public URI getTransformation() {
        if (this.myTransfURI == null) {
            this.myTransfURI = URI.createURI((String)myTransfPath);
        }
        return this.myTransfURI;
    }
}

