/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.bundles.tests;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.bundles.tests.BundlesTests;
import org.eclipse.papyrus.internal.bundles.tests.PapyrusBundleDescriptionRegistry;
import org.osgi.framework.Bundle;

public class PapyrusBundleDescription {
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final String BUNDLE_VERSION = "bundle-version=";
    private static final String VISIBILITY_REEXPORT = "visibility:=reexport";
    private static final String RESOLUTION_OPTIONAL = "resolution:=optional";
    private static final String X_INSTALLATION_GREEDY = "x-installation:=greedy";
    private static final String REGEX_START_GROUP = "(";
    private static final String REGEX_END_GROUP = ")";
    private static final String REGEX_OPTIONAL = "?";
    private static final String PROPERTY_SEPARATOR = ";";
    private static final String BUNDLE_NAME_REGEX_GROUP_1 = "([a-zA-Z0-9_\\.]*)";
    private static final String BUNDLE_VERSION_REGEX_GROUP_2 = "(;bundle-version=\"[\\[\\(\\d\\.\\]\\),]*\")";
    private static final String BUNDLE_OPTIONAL_REGEX_GROUP_3 = "(;resolution:=optional)";
    private static final String BUNDLE_REEXPORT_REGEX_GROUP_4 = "(;visibility:=reexport)";
    private static final String BUNDLE_GREEDY_GROUP_5 = "(;x-installation:=greedy)";
    private static final String DEPENDENCY_SEPARATOR_REGEX_GROUP = "(,)";
    private static final Pattern PATTERN = Pattern.compile("([a-zA-Z0-9_\\.]*)(;bundle-version=\"[\\[\\(\\d\\.\\]\\),]*\")?(;resolution:=optional)?(;visibility:=reexport)?(;x-installation:=greedy)?(,)?");
    private Bundle bundle;
    private Map<PapyrusBundleDescription, BundlesTests.Version> dependencies;
    private Set<PapyrusBundleDescription> reexportedDependencies;
    private Set<PapyrusBundleDescription> optionalDependencies;
    private Set<PapyrusBundleDescription> greedyDependencies;

    public PapyrusBundleDescription(String bundleName) {
        this(Platform.getBundle((String)bundleName));
    }

    private PapyrusBundleDescription(Bundle bundle) {
        Assert.isNotNull((Object)bundle);
        this.bundle = bundle;
    }

    public Collection<PapyrusBundleDescription> getDependencies() {
        if (this.dependencies == null) {
            this.initDependenciesFields();
        }
        return new HashSet<PapyrusBundleDescription>(this.dependencies.keySet());
    }

    public Collection<PapyrusBundleDescription> getReexportedDependencies() {
        if (this.reexportedDependencies == null) {
            this.initDependenciesFields();
        }
        return new HashSet<PapyrusBundleDescription>(this.reexportedDependencies);
    }

    public Collection<PapyrusBundleDescription> getOptionalDependencies() {
        if (this.optionalDependencies == null) {
            this.initDependenciesFields();
        }
        return new HashSet<PapyrusBundleDescription>(this.optionalDependencies);
    }

    public Collection<PapyrusBundleDescription> getGreedyDependencies() {
        if (this.greedyDependencies == null) {
            this.initDependenciesFields();
        }
        return new HashSet<PapyrusBundleDescription>(this.greedyDependencies);
    }

    private void initDependenciesFields() {
        this.dependencies = new HashMap<PapyrusBundleDescription, BundlesTests.Version>();
        this.reexportedDependencies = new HashSet<PapyrusBundleDescription>();
        this.optionalDependencies = new HashSet<PapyrusBundleDescription>();
        this.greedyDependencies = new HashSet<PapyrusBundleDescription>();
        String value = (String)this.bundle.getHeaders().get(REQUIRE_BUNDLE);
        Matcher matcher = PATTERN.matcher(value);
        while (matcher.find()) {
            String dependencyNameGroup1 = matcher.group(1);
            String versionGroup2 = matcher.group(2);
            String optionalGroup3 = matcher.group(3);
            String reexportGroup4 = matcher.group(4);
            String greedyGroup5 = matcher.group(5);
            if (dependencyNameGroup1 == null || dependencyNameGroup1.isEmpty()) continue;
            PapyrusBundleDescription newContainer = PapyrusBundleDescriptionRegistry.INSTANCE.getPapyrusBundleDescription(dependencyNameGroup1);
            if (versionGroup2 != null && !versionGroup2.isEmpty()) {
                Assert.isTrue((boolean)versionGroup2.contains(BUNDLE_VERSION), (String)NLS.bind((String)"Please, fill a bug, the regex doesn't work for {0}.", (Object)this.bundle.getSymbolicName()));
                String version = versionGroup2.replaceFirst(";bundle-version=\"", "");
                version = version.substring(0, version.length() - 1);
                this.dependencies.put(newContainer, new BundlesTests.Version(versionGroup2));
            } else {
                this.dependencies.put(newContainer, new BundlesTests.Version(null));
            }
            if (optionalGroup3 != null && !optionalGroup3.isEmpty()) {
                Assert.isTrue((boolean)optionalGroup3.contains(RESOLUTION_OPTIONAL), (String)NLS.bind((String)"Please, fill a bug, the regex doesn't work for {0}.", (Object)this.bundle.getSymbolicName()));
                this.optionalDependencies.add(newContainer);
            }
            if (reexportGroup4 != null && !reexportGroup4.isEmpty()) {
                Assert.isTrue((boolean)reexportGroup4.contains(VISIBILITY_REEXPORT), (String)NLS.bind((String)"Please, fill a bug, the regex doesn't work for {0}.", (Object)this.bundle.getSymbolicName()));
                this.reexportedDependencies.add(newContainer);
            }
            if (greedyGroup5 == null || greedyGroup5.isEmpty()) continue;
            Assert.isTrue((boolean)greedyGroup5.contains(X_INSTALLATION_GREEDY), (String)NLS.bind((String)"Please, fill a bug, the regex doesn't work for {0}.", (Object)this.bundle.getSymbolicName()));
            this.greedyDependencies.add(newContainer);
        }
    }

    public BundlesTests.Version getRegisteredDependencyVersion(PapyrusBundleDescription aDependency) {
        Assert.isNotNull((Object)aDependency);
        if (!this.dependencies.containsKey(aDependency)) {
            return null;
        }
        return this.dependencies.get(aDependency);
    }

    public BundlesTests.Version getRegisteredDependencyVersion(String dependencyName) {
        PapyrusBundleDescription currentDesc = PapyrusBundleDescriptionRegistry.INSTANCE.getPapyrusBundleDescription(dependencyName);
        if (currentDesc != null) {
            return this.getRegisteredDependencyVersion(currentDesc);
        }
        return null;
    }

    public final String getBundleSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    public static final Set<String> asSymbolicNameSet(Collection<PapyrusBundleDescription> coll) {
        HashSet<String> values = new HashSet<String>();
        for (PapyrusBundleDescription curr : coll) {
            values.add(curr.getBundleSymbolicName());
        }
        return values;
    }

    public boolean hasDependencyOn(String dependencyName) {
        return this.hasDependencyOn(PapyrusBundleDescriptionRegistry.INSTANCE.getPapyrusBundleDescription(dependencyName));
    }

    public boolean hasDependencyOn(PapyrusBundleDescription aPossibleDependency) {
        return this.dependencies.containsKey(aPossibleDependency);
    }

    public String toString() {
        return "Represented bundle: " + this.bundle.getSymbolicName();
    }
}

