/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.diagram.editparts.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class CompartmentEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private impl.diagram.editparts.CompartmentEditPart xptCompartmentEditPartImpl;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  public CharSequence qualifiedClassName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.xptCompartmentEditPartImpl.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.xptCompartmentEditPartImpl.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.xptCompartmentEditPartImpl.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.xptCompartmentEditPartImpl.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.xptCompartmentEditPartImpl.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _hasModelChildrenChanged = this.xptCompartmentEditPartImpl.hasModelChildrenChanged(it);
    _builder.append(_hasModelChildrenChanged, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _compartmentName = this.xptCompartmentEditPartImpl.getCompartmentName(it);
    _builder.append(_compartmentName, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createFigure = this.xptCompartmentEditPartImpl.createFigure(it);
    _builder.append(_createFigure, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
    _builder.append(_createDefaultEditPolicies, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshVisuals = this.xptCompartmentEditPartImpl.refreshVisuals(it);
    _builder.append(_refreshVisuals, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleNotificationEvent = this.handleNotificationEvent(it);
    _builder.append(_handleNotificationEvent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshBounds = this.xptCompartmentEditPartImpl.refreshBounds(it);
    _builder.append(_refreshBounds, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setRatio = this.xptCompartmentEditPartImpl.setRatio(it);
    _builder.append(_setRatio, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _targetEditPartMethod = this.xptCompartmentEditPartImpl.getTargetEditPartMethod(it);
    _builder.append(_targetEditPartMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends ");
    {
      boolean _isListLayout = it.isListLayout();
      if (_isListLayout) {
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart");
      } else {
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence implementsList(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence attributes(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence createDefaultEditPolicies(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void createDefaultEditPolicies() {");
    _builder.newLine();
    _builder.append("\t");
    Object _createDefaultEditPoliciesBody = this.xptCompartmentEditPartImpl.createDefaultEditPoliciesBody(it);
    _builder.append(_createDefaultEditPoliciesBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleNotificationEvent(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isStoringChildPositions = this._utils_qvto.isStoringChildPositions(it.getNode());
      if (_isStoringChildPositions) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification notification) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _handleNotificationEventBody = this.xptCompartmentEditPartImpl.handleNotificationEventBody(it);
        _builder.append(_handleNotificationEventBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence additions(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
