/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.papyrus.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.papyrus.gmf.internal.xpand.util.TypesComparator;

public class PolymorphicResolver {
    public static XpandDefinition filterDefinition(final HashMap<XpandDefinition, List<EClassifier>> resolvedDefs, EClassifier targetType, List<EClassifier> paramTypes, EcoreEnvironment env) throws AmbiguousDefinitionException {
        ArrayList<EClassifier> allParams = new ArrayList<EClassifier>();
        allParams.add(targetType);
        allParams.addAll(paramTypes);
        final TypesComparator typesComparator = new TypesComparator(env);
        ArrayList<XpandDefinition> candidateDefinition = new ArrayList<XpandDefinition>();
        for (XpandDefinition def : resolvedDefs.keySet()) {
            List<EClassifier> featureParamTypes = resolvedDefs.get(def);
            if (featureParamTypes.size() != allParams.size() || typesComparator.compare((List<? extends EClassifier>)featureParamTypes, (List<? extends EClassifier>)allParams) < 0) continue;
            candidateDefinition.add(def);
        }
        Comparator<XpandDefinition> comparator = new Comparator<XpandDefinition>(){

            @Override
            public int compare(XpandDefinition d1, XpandDefinition d2) {
                return typesComparator.compare((List)resolvedDefs.get(d1), (List)resolvedDefs.get(d2));
            }
        };
        try {
            return PolymorphicResolver.filterWithComparator(candidateDefinition, comparator);
        }
        catch (IllegalStateException ex) {
            throw new AmbiguousDefinitionException((XpandDefinition)candidateDefinition.get(0), (XpandDefinition)candidateDefinition.get(1));
        }
    }

    private static <T> T filterWithComparator(List<T> candidates, Comparator<T> comparator) throws IllegalStateException {
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Collections.sort(candidates, comparator);
        if (comparator.compare(candidates.get(1), candidates.get(0)) > 0) {
            return candidates.get(0);
        }
        throw new IllegalStateException();
    }
}

