/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ast.analyze;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.papyrus.gmf.internal.xpand.ast.AbstractAstVisitor;
import org.eclipse.papyrus.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.DeclaredParameter;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.ExpressionHelper;

public class UnusedMetamodelsCollector
extends AbstractAstVisitor {
    private LinkedHashSet<EPackage> myUnusedEPackages;
    private ExecutionContext myContext;

    public UnusedMetamodelsCollector(Set<EPackage> ePackages, ExecutionContext context) {
        this.myUnusedEPackages = new LinkedHashSet<EPackage>(ePackages);
        this.myContext = context;
    }

    public Set<EPackage> getUnusedEPackages() {
        return this.myUnusedEPackages;
    }

    @Override
    protected boolean visit(AbstractDefinition definition) {
        if (this.myUnusedEPackages.size() == 0) {
            return false;
        }
        EClassifier type = definition.getType().getTypeForName(this.myContext);
        if (type != null) {
            this.myUnusedEPackages.remove(type.getEPackage());
        }
        DeclaredParameter[] declaredParameterArray = definition.getParemeters();
        int n = declaredParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeclaredParameter parameter = declaredParameterArray[n2];
            type = parameter.getTypeForName(this.myContext);
            if (type != null) {
                this.myUnusedEPackages.remove(type.getEPackage());
            }
            ++n2;
        }
        return super.visit(definition);
    }

    @Override
    protected void visitExpressionHelper(ExpressionHelper expressionHelper) {
        if (this.myUnusedEPackages.size() == 0) {
            return;
        }
        if (expressionHelper.getOCLExpression() != null) {
            this.purgeUsedEPackages((EObject)expressionHelper.getOCLExpression());
            TreeIterator it = expressionHelper.getOCLExpression().eAllContents();
            while (it.hasNext()) {
                this.purgeUsedEPackages((EObject)it.next());
            }
        }
    }

    private void purgeUsedEPackages(EObject oclAstElement) {
        TypeExp typeExpression;
        if (oclAstElement instanceof TypeExp && (typeExpression = (TypeExp)oclAstElement).getReferredType() != null) {
            this.myUnusedEPackages.remove(((EClassifier)typeExpression.getReferredType()).getEPackage());
        }
    }
}

