/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.util.ElementTypesConfigurationsSwitch;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesDependencies;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.LocalProfileIndex;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.util.ApplyStereotypeAdviceSwitch;
import org.eclipse.papyrus.uml.types.core.advices.stereotypepropertyreferenceedgeadvice.StereotypePropertyReferenceEdgeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.core.advices.stereotypepropertyreferenceedgeadvice.util.StereotypePropertyReferenceEdgeAdviceSwitch;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.util.StereotypeApplicationMatcherSwitch;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

class ElementTypesBuildPropertiesDependencies {
    private final Resource resource;

    ElementTypesBuildPropertiesDependencies(Resource resource) {
        this.resource = resource;
    }

    Collection<IResource> getDependencies() {
        HashSet<IResource> result = new HashSet<IResource>();
        LocalProfileIndex index = LocalProfileIndex.getInstance(this.resource.getResourceSet());
        Set<Profile> profiles = this.collectProfiles(index, (List<EObject>)this.resource.getContents());
        for (Profile next : profiles) {
            Resource resource = next.eResource();
            IFile profileFile = ResourceUtils.getFile((Resource)resource);
            if (profileFile == null) continue;
            result.add((IResource)profileFile);
        }
        Set<URI> iconURIs = this.collectIcons((List<EObject>)this.resource.getContents());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (URI next : iconURIs) {
            String projectName;
            IProject project;
            if (!next.isPlatformPlugin() && !next.isPlatformResource() || (project = root.getProject(projectName = next.segment(1))) == null || !project.isAccessible()) continue;
            IFile icon = root.getFile((IPath)new Path(next.toPlatformString(false)));
            result.add((IResource)icon);
        }
        return result;
    }

    private Set<Profile> collectProfiles(final LocalProfileIndex index, List<EObject> objects) {
        final HashSet<Profile> result = new HashSet<Profile>();
        ApplyStereotypeAdviceSwitch<Set<Profile>> applyStereotypeSwitch = new ApplyStereotypeAdviceSwitch<Set<Profile>>(){

            public Set<Profile> caseStereotypeToApply(StereotypeToApply object) {
                Stereotype stereotype;
                if (object.getStereotypeQualifiedName() != null && (stereotype = index.getStereotype(object.getStereotypeQualifiedName(), (Collection<String>)object.getRequiredProfiles(), (EObject)object)) != null) {
                    result.add(stereotype.containingProfile());
                }
                return result;
            }
        };
        StereotypeApplicationMatcherSwitch<Set<Profile>> stereotypeMatcherSwitch = new StereotypeApplicationMatcherSwitch<Set<Profile>>(){

            public Set<Profile> caseStereotypeApplicationMatcherConfiguration(StereotypeApplicationMatcherConfiguration object) {
                if (object.getProfileUri() != null) {
                    Profile profile = index.getProfileByURI(object.getProfileUri(), (EObject)object);
                    if (profile != null) {
                        result.add(profile);
                    }
                } else {
                    object.getStereotypesQualifiedNames().stream().map(name -> index.getStereotype((String)name, (EObject)object)).filter(Objects::nonNull).map(Stereotype::containingProfile).forEach(result::add);
                }
                return result;
            }
        };
        StereotypePropertyReferenceEdgeAdviceSwitch<Set<Profile>> stereotypeReferenceSwitch = new StereotypePropertyReferenceEdgeAdviceSwitch<Set<Profile>>(){

            public Set<Profile> caseStereotypePropertyReferenceEdgeAdviceConfiguration(StereotypePropertyReferenceEdgeAdviceConfiguration object) {
                Stereotype stereotype;
                if (object.getStereotypeQualifiedName() != null && (stereotype = index.getStereotype(object.getStereotypeQualifiedName(), (EObject)object)) != null) {
                    result.add(stereotype.containingProfile());
                }
                return result;
            }
        };
        ElementTypesConfigurationsSwitch<Set<Profile>> master = new ElementTypesConfigurationsSwitch<Set<Profile>>((Switch)applyStereotypeSwitch, (Switch)stereotypeMatcherSwitch, (Switch)stereotypeReferenceSwitch){
            private final /* synthetic */ Switch val$applyStereotypeSwitch;
            private final /* synthetic */ Switch val$stereotypeMatcherSwitch;
            private final /* synthetic */ Switch val$stereotypeReferenceSwitch;
            {
                this.val$applyStereotypeSwitch = switch_;
                this.val$stereotypeMatcherSwitch = switch_2;
                this.val$stereotypeReferenceSwitch = switch_3;
            }

            public Set<Profile> defaultCase(EObject object) {
                object.eContents().forEach(eObject -> this.doSwitch((EObject)eObject));
                return result;
            }

            public Set<Profile> doSwitch(EObject eObject) {
                Object profiles = (Set)this.val$applyStereotypeSwitch.doSwitch(eObject);
                if (profiles == null) {
                    profiles = (Set)this.val$stereotypeMatcherSwitch.doSwitch(eObject);
                }
                if (profiles == null) {
                    profiles = (Set)this.val$stereotypeReferenceSwitch.doSwitch(eObject);
                }
                if (profiles == null) {
                    profiles = this.defaultCase(eObject);
                }
                return profiles;
            }
        };
        objects.forEach(arg_0 -> ((Switch)master).doSwitch(arg_0));
        return result;
    }

    private Set<URI> collectIcons(List<EObject> objects) {
        final HashSet<URI> result = new HashSet<URI>();
        ElementTypesConfigurationsSwitch<Set<URI>> iconsSwitch = new ElementTypesConfigurationsSwitch<Set<URI>>(){

            public Set<URI> caseIconEntry(IconEntry object) {
                try {
                    ElementTypesDependencies.getIconURI(object).ifPresent(result::add);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            public Set<URI> defaultCase(EObject object) {
                object.eContents().forEach(arg_0 -> (this).doSwitch(arg_0));
                return result;
            }
        };
        objects.forEach(arg_0 -> ((Switch)iconsSwitch).doSwitch(arg_0));
        return result;
    }
}

